<?php
App::uses('AppController', 'Controller');
/**
 * SignsUsers Controller
 * Generated by Petit Four the online baking tool for CakePHP: http://patisserie.keensoftware.com
 * @property SignsUser $SignsUser
 */
class SignsUsersController extends AppController {

/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->SignsUser->recursive = 0;
		$this->set('signsUsers', $this->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param string id
 * @return void
 */
	public function view($id = null) {
		if (!$this->SignsUser->exists($id)) {
			throw new NotFoundException(__('Invalid signs user'));
		}
		$options = array('conditions' => array('SignsUser.' . $this->SignsUser->primaryKey => $id));
		$this->set('signsUser', $this->SignsUser->find('first', $options));
	}

/**
 * add method
 *
 * @return void
 */
	public function add() {
		if ($this->request->is('post')) {
			$this->SignsUser->create();
			if ($this->SignsUser->save($this->request->data)) {
				$this->Session->setFlash(__('The signs user has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The signs user could not be saved. Please, try again.'));
			}
		}
		$signs = $this->SignsUser->Sign->find('list');
		$users = $this->SignsUser->User->find('list');
		$this->set(compact('signs', 'users'));
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param string id
 * @return void
 */
	public function edit($id = null) {
		if (!$this->SignsUser->exists($id)) {
			throw new NotFoundException(__('Invalid signs user'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->SignsUser->save($this->request->data)) {
				$this->Session->setFlash(__('The signs user has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The signs user could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('SignsUser.' . $this->SignsUser->primaryKey => $id));
			$this->request->data = $this->SignsUser->find('first', $options);
		}
		$signs = $this->SignsUser->Sign->find('list');
		$users = $this->SignsUser->User->find('list');
		$this->set(compact('signs', 'users'));
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param string id
 * @return void
 */
	public function delete($id = null) {
		$this->SignsUser->id = $id;
		if (!$this->SignsUser->exists()) {
			throw new NotFoundException(__('Invalid signs user'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->SignsUser->delete()) {
			$this->Session->setFlash(__('The signs user has been deleted.'));
		} else {
			$this->Session->setFlash(__('The signs user could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}
}
