<?php
App::uses('AppController', 'Controller');
/**
 * Signs Controller
 * Generated by Petit Four the online baking tool for CakePHP: http://patisserie.keensoftware.com
 * @property Sign $Sign
 */
class SignsController extends AppController {

/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->Sign->recursive = 0;
		$this->set('signs', $this->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function view($id = null) {
		if (!$this->Sign->exists($id)) {
			throw new NotFoundException(__('Invalid sign'));
		}
		$options = array('conditions' => array('Sign.' . $this->Sign->primaryKey => $id));
		$this->set('sign', $this->Sign->find('first', $options));
	}

/**
 * add method
 *
 * @return void
 */
	public function add() {
		if ($this->request->is('post')) {
			$this->Sign->create();
			if ($this->Sign->save($this->request->data)) {
				$this->Session->setFlash(__('The sign has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The sign could not be saved. Please, try again.'));
			}
		}
		$groups = $this->Sign->Group->find('list');
		$this->set(compact('groups'));
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function edit($id = null) {
		if (!$this->Sign->exists($id)) {
			throw new NotFoundException(__('Invalid sign'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->Sign->save($this->request->data)) {
				$this->Session->setFlash(__('The sign has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The sign could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Sign.' . $this->Sign->primaryKey => $id));
			$this->request->data = $this->Sign->find('first', $options);
		}
		$groups = $this->Sign->Group->find('list');
		$this->set(compact('groups'));
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param int id
 * @return void
 */
	public function delete($id = null) {
		$this->Sign->id = $id;
		if (!$this->Sign->exists()) {
			throw new NotFoundException(__('Invalid sign'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Sign->delete()) {
			$this->Session->setFlash(__('The sign has been deleted.'));
		} else {
			$this->Session->setFlash(__('The sign could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}
}
