<?php
App::uses('AppController', 'Controller');
/**
 * Retailpoints Controller
 * Generated by Petit Four the online baking tool for CakePHP: http://patisserie.keensoftware.com
 * @property Retailpoint $Retailpoint
 */
class RetailpointsController extends AppController {

/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->Retailpoint->recursive = 0;
		$this->set('retailpoints', $this->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function view($id = null) {
		if (!$this->Retailpoint->exists($id)) {
			throw new NotFoundException(__('Invalid retailpoint'));
		}
		$options = array('conditions' => array('Retailpoint.' . $this->Retailpoint->primaryKey => $id));
		$this->set('retailpoint', $this->Retailpoint->find('first', $options));
	}

/**
 * add method
 *
 * @return void
 */
	public function add() {
		if ($this->request->is('post')) {
			$this->Retailpoint->create();
			if ($this->Retailpoint->save($this->request->data)) {
				$this->Session->setFlash(__('The retailpoint has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The retailpoint could not be saved. Please, try again.'));
			}
		}
		$signs = $this->Retailpoint->Sign->find('list');
		$districts = $this->Retailpoint->District->find('list');
		$this->set(compact('signs', 'districts'));
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function edit($id = null) {
		if (!$this->Retailpoint->exists($id)) {
			throw new NotFoundException(__('Invalid retailpoint'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->Retailpoint->save($this->request->data)) {
				$this->Session->setFlash(__('The retailpoint has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The retailpoint could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Retailpoint.' . $this->Retailpoint->primaryKey => $id));
			$this->request->data = $this->Retailpoint->find('first', $options);
		}
		$signs = $this->Retailpoint->Sign->find('list');
		$districts = $this->Retailpoint->District->find('list');
		$this->set(compact('signs', 'districts'));
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param int id
 * @return void
 */
	public function delete($id = null) {
		$this->Retailpoint->id = $id;
		if (!$this->Retailpoint->exists()) {
			throw new NotFoundException(__('Invalid retailpoint'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Retailpoint->delete()) {
			$this->Session->setFlash(__('The retailpoint has been deleted.'));
		} else {
			$this->Session->setFlash(__('The retailpoint could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}
}
