<?php
App::uses('AppModel', 'Model');
/**
 * Sign Model
 *
 * @property Group $Group
 * @property Retailpoint $Retailpoint
 * @property SignsUser $SignsUser
 */
class Sign extends AppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';


	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'Group' => array(
			'className' => 'Group',
			'foreignKey' => 'group_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'Retailpoint' => array(
			'className' => 'Retailpoint',
			'foreignKey' => 'sign_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'SignsUser' => array(
			'className' => 'SignsUser',
			'foreignKey' => 'sign_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);
        
        protected $_displayFields = array(
		'id',
		'name'=>'Nome',
		'label'=>'Insegna',
                'Group.name'=>'Gruppo',
                'created' => 'Creato'
	);
        protected $_editFields = array(
		'name'=>'Nome',
		'label'=>'Insegna',
                'group_id'=>'Gruppo'
	);        

	public function __construct($id=false,$table=false,$ds=false){
		parent::__construct($id,$table,$ds);
			$this->virtualFields = array(
			    'imagePath' => sprintf('CONCAT("http://","%s", "/", "%s")', $_SERVER['HTTP_HOST'],  Configure::read("Users.imagesPath"))
			);
	}
        
}
