<?php
App::uses('AppController', 'Controller');

class SignsController extends AppController {
	
/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->Sign->recursive = 0;
		$this->set('signs', $this->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function view($id = null) {
		if (!$this->Sign->exists($id)) {
			throw new NotFoundException(__('Invalid sign'));
		}
		$options = array('conditions' => array('Sign.' . $this->Sign->primaryKey => $id));
		$this->set('sign', $this->Sign->find('first', $options));
	}

/**
 * add method
 *
 * @return void
 */
	public function add() {
		if ($this->request->is('post')) {
			$this->Sign->create();
			pr($this->request->data);die();
			if ($this->Sign->save($this->request->data)) {
				$this->Session->setFlash(__('The sign has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The sign could not be saved. Please, try again.'));
			}
		}
		$groups = $this->Sign->Group->find('list');
		$this->set(compact('groups'));
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function edit($id = null) {
		if (!$this->Sign->exists($id)) {
			throw new NotFoundException(__('Invalid sign'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->Sign->save($this->request->data)) {
				$this->Session->setFlash(__('The sign has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The sign could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Sign.' . $this->Sign->primaryKey => $id));
			$this->request->data = $this->Sign->find('first', $options);
		}
		$groups = $this->Sign->Group->find('list');
		$this->set(compact('groups'));
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param int id
 * @return void
 */
	public function delete($id = null) {
		$this->Sign->id = $id;
		if (!$this->Sign->exists()) {
			throw new NotFoundException(__('Invalid sign'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Sign->delete()) {
			$this->Session->setFlash(__('The sign has been deleted.'));
		} else {
			$this->Session->setFlash(__('The sign could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}

/**
 * index method
 *
 * @return void
 */
	public function admin_index() {
		$this->Sign->recursive = 0;
		$loggedInUser = AuthComponent::user();
		$user = AuthComponent::user();
		$userId = $user['id'];
		$signs = $this->Sign->find('all', array('conditions' => array('Sign.user_id' => $userId)));
		//pr($signs);die();
		$this->set('signs', $signs);
		$this->set('displayFields', $this->Sign->displayFields());
		/*
		$this->Tag->recursive = 0;
		
		$this->set('tags', $this->Tag->find('all'));
		$this->set('displayFields', $this->Tag->displayFields());
		*/
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function admin_view($id = null) {
		if (!$this->Sign->exists($id)) {
			throw new NotFoundException(__('Invalid sign'));
		}
		$options = array('conditions' => array('Sign.' . $this->Sign->primaryKey => $id));
		$this->set('sign', $this->Sign->find('first', $options));
	}

/**
 * add method
 *
 * @return void
 */
	public function admin_add() {
		$loggedInUser = AuthComponent::user();
		$user = AuthComponent::user();
		$userId = $user['id'];
		$userdir= $user['activation_key'];
		$this->set('editFields', $this->Sign->editFields());
		if ($this->request->is('post')) {
			$this->Sign->create();
			$this->request->data['Sign']['user_id'] = $userId;
			if ($this->Sign->save($this->request->data)) {
				{
				    move_uploaded_file(
					$this->request->data['Sign']['image']['tmp_name'],
					WWW_ROOT.Configure::read("Users.imagesDir"). DS . $userdir . DS . "signs" . DS . $this->Sign->id . '.jpg'
				    );
				}				
				$this->Session->setFlash(__('The sign has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The sign could not be saved. Please, try again.'));
			}
		}
		$groups = $this->Sign->Group->find('list', array('conditions' => array('Group.user_id' => $userId)));

		//$groups = $this->Sign->Group->find('list');
		$this->set(compact('groups'));
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function admin_edit($id = null) {
		$loggedInUser = AuthComponent::user();
		$user = AuthComponent::user();
		$userId = $user['id'];
		$userdir= $user['activation_key'];
		$this->set('editFields', $this->Sign->editFields());
		if (!$this->Sign->exists($id)) {
			throw new NotFoundException(__('Invalid sign'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
				//pr($this->request);
				//echo (WWW_ROOT.Configure::read("Sign.imagesPath"). "\\img\\" . $userdir . "\\" . $this->Sign->id . '.jpg');
				//die();
			if ($this->Sign->save($this->request->data)) {
				if (is_uploaded_file($this->request->data['Sign']['image']['tmp_name']))
				{
				    move_uploaded_file(
					$this->request->data['Sign']['image']['tmp_name'],
					WWW_ROOT.Configure::read("Users.imagesDir"). DS . $userdir . DS . "signs" . DS . $this->Sign->id . '.jpg'
				    );
				}
				
				$this->Session->setFlash(__('The sign has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The sign could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Sign.' . $this->Sign->primaryKey => $id, 'Sign.user_id' => $userId));
			$signs = $this->Sign->find('first', $options);
			if (sizeof($signs) == 0)
			{
				$this->Session->setFlash(__('Insegna non valida'));
				return $this->redirect(array('action' => 'index'));
			}
			else
				$this->request->data = $signs;
			
		}
		$groups = $this->Sign->Group->find('list', array('conditions' => array('Group.user_id' => $userId)));
		
		//$groups = $this->Sign->Group->find('list');
		$this->set(compact('groups','userdir'));
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param int id
 * @return void
 */
	public function admin_delete($id = null) {
		$this->Sign->id = $id;
		if (!$this->Sign->exists()) {
			throw new NotFoundException(__('Invalid sign'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Sign->delete()) {
			$this->Session->setFlash(__('The sign has been deleted.'));
		} else {
			$this->Session->setFlash(__('The sign could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}
}
