<?php
App::uses('AppController', 'Controller');
/**
 * Promos Controller
 * Generated by Petit Four the online baking tool for CakePHP: http://patisserie.keensoftware.com
 * @property Promo $Promo
 */
class PromosController extends AppController {

/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->Promo->recursive = 0;
		$this->set('promos', $this->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function view($id = null) {
		if (!$this->Promo->exists($id)) {
			throw new NotFoundException(__('Invalid promo'));
		}
		$options = array('conditions' => array('Promo.' . $this->Promo->primaryKey => $id));
		$this->set('promo', $this->Promo->find('first', $options));
	}

/**
 * add method
 *
 * @return void
 */
	public function add() {
		if ($this->request->is('post')) {
			$this->Promo->create();
			if ($this->Promo->save($this->request->data)) {
				$this->Session->setFlash(__('The promo has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The promo could not be saved. Please, try again.'));
			}
		}
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function edit($id = null) {
		if (!$this->Promo->exists($id)) {
			throw new NotFoundException(__('Invalid promo'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->Promo->save($this->request->data)) {
				$this->Session->setFlash(__('The promo has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The promo could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Promo.' . $this->Promo->primaryKey => $id));
			$this->request->data = $this->Promo->find('first', $options);
		}
	}


	public function admin_index() {
		//$this->Promo->recursive = 0;
		//$this->set('promos', $this->paginate());
		
		$this->Promo->recursive = 0;
		$loggedInUser = AuthComponent::user();
		$user = AuthComponent::user();
		$userId = $user['id'];
		$promos = $this->Promo->find('all', array('conditions' => array('Promo.user_id' => $userId)));
		//pr($signs);die();
		$this->set('promos', $promos);
		$this->set('displayFields', $this->Promo->displayFields());		
		
	}

	
	
/**
 * view method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function admin_view($id = null) {
		if (!$this->Promo->exists($id)) {
			throw new NotFoundException(__('Invalid promo'));
		}
		$options = array('conditions' => array('Promo.' . $this->Promo->primaryKey => $id));
		$this->set('promo', $this->Promo->find('first', $options));
	}

/**
 * add method
 *
 * @return void
 */
	public function admin_add() {
		$loggedInUser = AuthComponent::user();
		$user = AuthComponent::user();
		$userId = $user['id'];
		$userdir= $user['activation_key'];
		$this->set('editFields', $this->Promo->editFields());
	
		if ($this->request->is('post')) {
			$this->Promo->create();

			$this->request->data['Promo']['user_id'] = $userId;
			if ($this->Promo->save($this->request->data)) {
				if (is_uploaded_file($this->request->data['Promo']['image']['tmp_name']))
				{
				    move_uploaded_file(
					$this->request->data['Promo']['image']['tmp_name'],
					WWW_ROOT.Configure::read("Users.imagesDir"). DS . $userdir . DS . "promos" . DS . $this->Promo->id . '.jpg'
				    );
				}				
				$this->Session->setFlash(__('The Promo has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The Promo could not be saved. Please, try again.'));
			}

		}
		$signs = $this->Promo->Sign->find('list', array('conditions' => array('Sign.user_id' => $userId)));
		$retailpoints = $this->Promo->Retailpoint->find('list', array('conditions' => array('Retailpoint.user_id' => $userId)));			
		$this->set(compact('signs','retailpoints'));	
		$allRP = array();
		foreach($signs as $key => $value)
		{
			$tmpretailpoints = $this->Promo->Retailpoint->find('list', array('conditions' => array('Retailpoint.user_id' => $userId, 'Retailpoint.sign_id' => $key)));
			$allRP[intval($key)] = $tmpretailpoints;
		}
		$jsonallRP = json_encode($allRP, JSON_OBJECT_AS_ARRAY);
		$this->set(compact('allRP','jsonallRP'));
	}

	
/*
	public function admin_add() {
		$loggedInUser = AuthComponent::user();
		$user = AuthComponent::user();
		$userId = $user['id'];
		$userdir= $user['activation_key'];
		$this->set('editFields', $this->Sign->editFields());
		if ($this->request->is('post')) {
			$this->Sign->create();
			$this->request->data['Sign']['user_id'] = $userId;
			if ($this->Sign->save($this->request->data)) {
				if (is_uploaded_file($this->request->data['Sign']['image']['tmp_name']))
				{
				    move_uploaded_file(
					$this->request->data['Sign']['image']['tmp_name'],
					WWW_ROOT.Configure::read("Sign.imagesPath"). "img\users\\" . $userdir . "\signs\\" . $this->Sign->id . '.jpg'
				    );
				}				
				$this->Session->setFlash(__('The sign has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The sign could not be saved. Please, try again.'));
			}
		}
		$groups = $this->Sign->Group->find('list', array('conditions' => array('Group.user_id' => $userId)));

		//$groups = $this->Sign->Group->find('list');
		$this->set(compact('groups'));
	}	
*/	
	
	
/**
 * edit method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function admin_edit($id = null) {
		$loggedInUser = AuthComponent::user();
		$user = AuthComponent::user();
		$userId = $user['id'];
		$userdir= $user['activation_key'];
		$this->set('editFields', $this->Promo->editFields());
		if (!$this->Promo->exists($id)) {
			throw new NotFoundException(__('Invalid Promo'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
				//pr($this->request);
				//echo (WWW_ROOT.Configure::read("Sign.imagesPath"). "\\img\\" . $userdir . "\\" . $this->Sign->id . '.jpg');
				//die();
			if ($this->Promo->save($this->request->data)) {
				if (is_uploaded_file($this->request->data['Promo']['image']['tmp_name']))
				{
				    move_uploaded_file(
					$this->request->data['Promo']['image']['tmp_name'],
					WWW_ROOT.Configure::read("Users.imagesDir"). DS . $userdir . DS . "promos" . DS . $this->Promo->id . '.jpg'
				    );
				}
				
				$this->Session->setFlash(__('The Promo has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The Promo could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Promo.' . $this->Promo->primaryKey => $id, 'Promo.user_id' => $userId));
			$data = $this->Promo->find('first', $options);
			if (sizeof($data) == 0)
			{
				$this->Session->setFlash(__('Promo non valida'));
				return $this->redirect(array('action' => 'index'));
			}
			else
				$this->request->data = $data;				
		}
		$signs = $this->Promo->Sign->find('list', array('conditions' => array('Sign.user_id' => $userId)));
		$retailpoints = $this->Promo->Retailpoint->find('list', array('conditions' => array('Retailpoint.user_id' => $userId)));			
		$this->set(compact('signs','retailpoints'));	
		$allRP = array();
		foreach($signs as $key => $value)
		{
			$tmpretailpoints = $this->Promo->Retailpoint->find('list', array('conditions' => array('Retailpoint.user_id' => $userId, 'Retailpoint.sign_id' => $key)));
			$allRP[intval($key)] = $tmpretailpoints;
		}
		$jsonallRP = json_encode($allRP, JSON_OBJECT_AS_ARRAY);
		$this->set(compact('allRP','jsonallRP'));
		
		//$groups = $this->Sign->Group->find('list');
		$this->set(compact('userdir'));
	}	
	
/**
 * delete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param int id
 * @return void
 */
	public function delete($id = null) {
		$this->Promo->id = $id;
		if (!$this->Promo->exists()) {
			throw new NotFoundException(__('Invalid promo'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Promo->delete()) {
			$this->Session->setFlash(__('The promo has been deleted.'));
		} else {
			$this->Session->setFlash(__('The promo could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}
	
	public function admin_delete($id = null) {
		$this->Promo->id = $id;
		if (!$this->Promo->exists()) {
			throw new NotFoundException(__('Invalid promo'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Promo->delete()) {
			$this->Session->setFlash(__('The promo has been deleted.'));
		} else {
			$this->Session->setFlash(__('The promo could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}
}
