<?php

if (file_exists(APP . 'Vendor/autoload.php')) {
	require APP . 'Vendor/autoload.php';
	spl_autoload_unregister(array('App', 'load'));
	spl_autoload_register(array('App', 'load'), true, true);
}

/**
 * This file is loaded automatically by the app/webroot/index.php file after the core bootstrap.php
 *
 * This is an application wide file to load any function that is not used within a class
 * define. You can also use this to include or require any files in your application.
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.app.config
 * @since         CakePHP(tm) v 0.10.8.2117
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

/**
 * The settings below can be used to set additional paths to models, views and controllers.
 * This is related to Ticket #470 (https://trac.cakephp.org/ticket/470)
 *
 * App::build(array(
 *     'plugins' => array('/full/path/to/plugins/', '/next/full/path/to/plugins/'),
 *     'models' =>  array('/full/path/to/models/', '/next/full/path/to/models/'),
 *     'views' => array('/full/path/to/views/', '/next/full/path/to/views/'),
 *     'controllers' => array('/full/path/to/controllers/', '/next/full/path/to/controllers/'),
 *     'datasources' => array('/full/path/to/datasources/', '/next/full/path/to/datasources/'),
 *     'behaviors' => array('/full/path/to/behaviors/', '/next/full/path/to/behaviors/'),
 *     'components' => array('/full/path/to/components/', '/next/full/path/to/components/'),
 *     'helpers' => array('/full/path/to/helpers/', '/next/full/path/to/helpers/'),
 *     'vendors' => array('/full/path/to/vendors/', '/next/full/path/to/vendors/'),
 *     'shells' => array('/full/path/to/shells/', '/next/full/path/to/shells/'),
 *     'locales' => array('/full/path/to/locale/', '/next/full/path/to/locale/')
 * ));
 *
 */

/**
 * As of 1.3, additional rules for the inflector are added below
 *
 * Inflector::rules('singular', array('rules' => array(), 'irregular' => array(), 'uninflected' => array()));
 * Inflector::rules('plural', array('rules' => array(), 'irregular' => array(), 'uninflected' => array()));
 *
 */
App::build(array(
	'Plugin' => array(APP . 'Vendor' . DS . 'croogo' . DS . 'croogo' . DS ),
), App::APPEND);

Configure::write('Dispatcher.filters', array(
	'AssetDispatcher',
	'CacheDispatcher'
));

CakeLog::config('debug', array(
	'engine' => 'File',
	'types' => array('notice', 'info', 'debug'),
	'file' => 'debug',
));
CakeLog::config('error', array(
	'engine' => 'File',
	'types' => array('warning', 'error', 'critical', 'alert', 'emergency'),
	'file' => 'error',
));

CakePlugin::load('Croogo', array('bootstrap' => true));

CroogoNav::add('sidebar', 'signs', array(
	'icon' => 'comments',
	'title' => __d('default', 'Signs'),
	'url' => array(
		'admin' => true,
		'plugin' => '',
		'controller' => 'signs',
		'action' => 'index',
	),
	'weight' => 50,
	'children' => array(
		'index' => array(
			'title' => __d('default', 'Signs'),
			'url' => array(
				'admin' => true,
				'plugin' => '',
				'controller' => 'signs',
				'action' => 'index',
			),
		),
		'add' => array(
			'title' => __d('default', 'Signs Add'),
			'url' => array(
				'admin' => true,
				'plugin' => '',
				'controller' => 'signs',
				'action' => 'add',
			),
		),
	),
));

CroogoNav::add('sidebar', 'groups', array(
	'icon' => 'comments',
	'title' => __d('default', 'Groups'),
	'url' => array(
		'admin' => true,
		'plugin' => '',
		'controller' => 'groups',
		'action' => 'index',
	),
	'weight' => 50,
	'children' => array(
		'index' => array(
			'title' => __d('default', 'Groups'),
			'url' => array(
				'admin' => true,
				'plugin' => '',
				'controller' => 'groups',
				'action' => 'index',
			),
		),
		'add' => array(
			'title' => __d('croogo', 'Groups Add'),
			'url' => array(
				'admin' => true,
				'plugin' => '',
				'controller' => 'groups',
				'action' => 'add',
			),
		),
	),
));

CroogoNav::add('sidebar', 'retailpoint', array(
	'icon' => 'comments',
	'title' => __d('default', 'Retailpoints'),
	'url' => array(
		'admin' => true,
		'plugin' => '',
		'controller' => 'retailpoints',
		'action' => 'index',
	),
	'weight' => 50,
	'children' => array(
		'index' => array(
			'title' => __d('default', 'Retailpoints'),
			'url' => array(
				'admin' => true,
				'plugin' => '',
				'controller' => 'retailpoints',
				'action' => 'index',
			),
		),
		'add' => array(
			'title' => __d('default', 'Retailpoints Add'),
			'url' => array(
				'admin' => true,
				'plugin' => '',
				'controller' => 'retailpoints',
				'action' => 'add',
			),
		),
	),
));

CroogoNav::add('sidebar', 'promo', array(
	'icon' => 'comments',
	'title' => __d('default', 'Promos'),
	'url' => array(
		'admin' => true,
		'plugin' => '',
		'controller' => 'promos',
		'action' => 'index',
	),
	'weight' => 50,
	'children' => array(
		'index' => array(
			'title' => __d('default', 'Promos'),
			'url' => array(
				'admin' => true,
				'plugin' => '',
				'controller' => 'promos',
				'action' => 'index',
			),
		),
		'add' => array(
			'title' => __d('default', 'Promos Add'),
			'url' => array(
				'admin' => true,
				'plugin' => '',
				'controller' => 'promos',
				'action' => 'add',
			),
		),
	),
));


Configure::write("Users.imagesDir",'img'.DS.'users');
Configure::write("Users.imagesPath",'img/users/');
