<?php
App::uses('AppModel', 'Model');
/**
 * Retailpoint Model
 *
 * @property Sign $Sign
 * @property District $District
 */
class Retailpoint extends AppModel {


	//The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'Sign' => array(
			'className' => 'Sign',
			'foreignKey' => 'sign_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'District' => array(
			'className' => 'District',
			'foreignKey' => 'district_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
                'Totemtype' => array(
			'className' => 'Totemtype',
			'foreignKey' => 'totemtype_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
                'Modetype' => array(
			'className' => 'Modetype',
			'foreignKey' => 'modetype_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)                
	);

        protected $_displayFields = array(
		'name'=>'Nome',
                'Sign.name'=>'Insegna',
                'District.name'=>'Provincia',
                'code'=>'Codice',
                'Totemtype.type'=>'Tipo Totem',
                'Modetype.type'=>'Tipo Percorso',               
                );
        
        protected $_editFields = array(
		'name'=>'Nome',
                'code'=>'Codice',
                'sign_id'=>'Insegna',
                'district_id'=>'Provincia',
                'totemtype_id' => 'Tipo Totem',
                'closingcards'=>'Carte chiusura',
                'address'=>'Indirizzo',
                'courtesypagetext'=>'Messaggio iniziale su totem',
                'adCd1'=>'AutoDialer Numero Principale',
                'adCd2'=>'AutoDialer Numero Secondario',
                'cli'=>'Numero CLI',				
                'adAudiofile'=>'AutoDialer File',
                'modetype_id'=>'Tipo Percorso',
	);         

	public $actsAs = array('Search.Searchable');
	public $filterArgs = array('name' => array('type' => 'like'),'sign_id' => array('type' => 'value'),'district_id' => array('type' => 'value'));	

	public function __construct($id=false,$table=false,$ds=false){
		parent::__construct($id,$table,$ds);
			$this->virtualFields = array(
			    'imagePath' => sprintf('CONCAT("http://","%s", "/", "%s")', $_SERVER['HTTP_HOST'],  Configure::read("Users.imagesPath"))
                            );
	}        
        
}
