<?php
App::uses('AppController', 'Controller');
class RetailpointsController extends AppController {

	public $components = array(
		'Search.Prg' => array(
			'presetForm' => array(
				'paramType' => 'querystring',
			),
			'commonProcess' => array(
				'paramType' => 'querystring',
				'filterEmpty' => true,
			),
		)
	);

	public function beforeFilter() {
		$this->Auth->allow('check');
		parent::beforeFilter();
		$this->Security->csrfCheck = false;
	}
	
/**
 * index method
 *
 * @return void
 */
	public function index() {
		$this->Retailpoint->recursive = 0;
		$this->set('retailpoints', $this->paginate());
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function view($id = null) {
		if (!$this->Retailpoint->exists($id)) {
			throw new NotFoundException(__('Invalid retailpoint'));
		}
		$options = array('conditions' => array('Retailpoint.' . $this->Retailpoint->primaryKey => $id));
		$this->set('retailpoint', $this->Retailpoint->find('first', $options));
	}

/**
 * add method
 *
 * @return void
 */
	public function add() {
		if ($this->request->is('post')) {
			$this->Retailpoint->create();
			if ($this->Retailpoint->save($this->request->data)) {
				$this->Session->setFlash(__('The retailpoint has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The retailpoint could not be saved. Please, try again.'));
			}
		}
		$signs = $this->Retailpoint->Sign->find('list');
		$districts = $this->Retailpoint->District->find('list');
		$this->set(compact('signs', 'districts'));
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function edit($id = null) {
		if (!$this->Retailpoint->exists($id)) {
			throw new NotFoundException(__('Invalid retailpoint'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->Retailpoint->save($this->request->data)) {
				$this->Session->setFlash(__('The retailpoint has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The retailpoint could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Retailpoint.' . $this->Retailpoint->primaryKey => $id));
			$this->request->data = $this->Retailpoint->find('first', $options);
		}

		$signs = $this->Retailpoint->Sign->find('list');
		$districts = $this->Retailpoint->District->find('list');
		$this->set(compact('signs', 'districts'));
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param int id
 * @return void
 */
	public function delete($id = null) {
		$this->Retailpoint->id = $id;
		if (!$this->Retailpoint->exists()) {
			throw new NotFoundException(__('Invalid retailpoint'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Retailpoint->delete()) {
			$this->Session->setFlash(__('The retailpoint has been deleted.'));
		} else {
			$this->Session->setFlash(__('The retailpoint could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}

	public function admin_index() {
		$this->Retailpoint->recursive = 0;
		// search criteria
		$this->Prg->commonProcess();
		$loggedInUser = AuthComponent::user();
		$user = AuthComponent::user();
		$userId = $user['id'];
		$conditions = array('Retailpoint.user_id' => $userId);
//		$retailpoints = $this->Retailpoint->find('all', array('conditions' => $conditions));		
		$criteria = $this->Retailpoint->parseCriteria($this->Prg->parsedParams());
		array_push($criteria, $conditions);
		$this->paginate['conditions'] = $criteria;
		$this->set('displayFields', $this->Retailpoint->displayFields());
		//$this->set('retailpoints', $retailpoints);
		$this->set('searchFields', array('name', 'sign_id', 'district_id'));
		$this->set('retailpoints', $this->paginate());
		
		$signs = $this->Retailpoint->Sign->find('list', array('conditions' => array('Sign.user_id' => $userId)));
		$dconditions = array('Retailpoint.user_id' => $userId);
		$districts = $this->Retailpoint->District->find('list');
		$this->set(compact('signs', 'districts'));
	}
	
	public function admin_add() {
		$loggedInUser = AuthComponent::user();
		$user = AuthComponent::user();
		
		$userId = $user['id'];
		$userdir= $user['activation_key'];
		$this->set('editFields', $this->Retailpoint->editFields());
		if ($this->request->is('post')) {
			//pr($this->request->data);
			$this->Retailpoint->create();
			$this->request->data['Retailpoint']['groups_id'] = $user['group_id'];
			$this->request->data['Retailpoint']['user_id'] = $userId;
			if ($this->Retailpoint->save($this->request->data)) {
				if (is_uploaded_file($this->request->data['Retailpoint']['Immagine']['tmp_name']))
				{
				    move_uploaded_file(
					$this->request->data['Retailpoint']['Immagine']['tmp_name'],
					WWW_ROOT.Configure::read("Users.imagesDir"). DS . $userdir . DS . "retailpoints" . DS . $this->Retailpoint->id . '.jpg'
				    );
				}				
				$this->Session->setFlash(__('The retailpoint has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The retailpoint could not be saved. Please, try again.'));
			}
		}
		$signs = $this->Retailpoint->Sign->find('list', array('conditions' => array('Sign.user_id' => $userId)));	
		$districts = $this->Retailpoint->District->find('list');
		$totemtypes = $this->Retailpoint->Totemtype->find('list',array('fields'=>array('id','type')));
		$modetypes = $this->Retailpoint->Modetype->find('list',array('fields'=>array('id','type')));
		$this->set(compact('signs', 'districts', 'totemtypes', 'modetypes'));
	}

/**
 * edit method
 *
 * @throws NotFoundException
 * @param int id
 * @return void
 */
	public function admin_edit($id = null) {
		$loggedInUser = AuthComponent::user();
		$user = AuthComponent::user();
		$userId = $user['id'];
		$userdir= $user['activation_key'];
		if (!$this->Retailpoint->exists($id)) {
			throw new NotFoundException(__('Invalid retailpoint'));
		}
		$this->set('editFields', $this->Retailpoint->editFields());
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->Retailpoint->save($this->request->data)) {
				if (is_uploaded_file($this->request->data['Retailpoint']['image']['tmp_name']))
				{
				    move_uploaded_file(
					$this->request->data['Retailpoint']['image']['tmp_name'],
					WWW_ROOT.Configure::read("Users.imagesDir"). DS . $userdir . DS . "retailpoints" . DS . $this->Retailpoint->id . '.jpg'
				    );
				}				
				$this->Session->setFlash(__('The retailpoint has been saved'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The retailpoint could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('Retailpoint.' . $this->Retailpoint->primaryKey => $id, 'Retailpoint.user_id' => $userId));
			$data = $this->Retailpoint->find('first', $options);
			if (sizeof($data) == 0)
			{
				$this->Session->setFlash(__('Punto vendita non valido'));
				return $this->redirect(array('action' => 'index'));
			}
			else
				$this->request->data = $data;			
		}
		
		$signs = $this->Retailpoint->Sign->find('list', array('conditions' => array('Sign.user_id' => $userId)));		
		$districts = $this->Retailpoint->District->find('list');
		$totemtypes = $this->Retailpoint->Totemtype->find('list',array('fields'=>array('id','type')));
		$modetypes = $this->Retailpoint->Modetype->find('list',array('fields'=>array('id','type')));
		$this->set(compact('signs','districts', 'userdir', 'totemtypes', 'modetypes'));
	}

/**
 * delete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param int id
 * @return void
 */
	public function admin_delete($id = null) {
		$this->Retailpoint->id = $id;
		if (!$this->Retailpoint->exists()) {
			throw new NotFoundException(__('Invalid retailpoint'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Retailpoint->delete()) {
			$this->Session->setFlash(__('The retailpoint has been deleted.'));
		} else {
			$this->Session->setFlash(__('The retailpoint could not be deleted. Please, try again.'));
		}
		return $this->redirect(array('action' => 'index'));
	}

	public function check(){
		if(!empty($this->request->query['id'])){
			$queryRetailPoints = 'SELECT retailpoints.*, users.activation_key as dir, users.autodialer_cli '.
			'FROM retailpoints '.
			'left join users on retailpoints.user_id = users.id ' .
			'where retailpoints.code = '. $this->request->query['id'];

			$rp = $this->Retailpoint->query($queryRetailPoints);
	
			$queryPromos = 'SELECT * '.
			'FROM  promos '.
			'where retailpoint_id = '. $rp[0]['retailpoints']['id']  . ' ' .//$this->request->query['id'] . ' ' .
			'and deleted = 0 ' .
			'and fromdate < now() and todate > now() ';
			
			$querySetting = 'SELECT * '.
			'FROM  rpsettings ';			
	 
			$retArray = array();
			$promos = array();
	  

			$pr = $this->Retailpoint->query($queryPromos);
			
			if (count($pr) == 0)
			{
					$queryPromos = 'SELECT * '.
					'FROM  promos '.
					'where sign_id = '. $rp[0]['retailpoints']['sign_id']  . ' ' .//$this->request->query['id'] . ' ' .
					'and deleted = 0 ' .
					'and fromdate < now() and todate > now() ';
					$pr = $this->Retailpoint->query($queryPromos);
			}
			
			$settings = $this->Retailpoint->query($querySetting);
			
			if (count($rp) > 0)
			{
				$retArray['retailpoint'] = $rp[0]['retailpoints'];
				$retArray['img'] = $rp[0]['users'];
				foreach($pr as $current)
				{
					array_push($promos, $current['promos']);
				}
			}
			$retArray['promos'] = $promos;
			$settings[0]['rpsettings']['adCli'] = $rp[0]['users']['autodialer_cli'];
			$retArray['settings'] = $settings[0]['rpsettings'];
			$this->set(array(
					'ret' => $retArray,
					'_serialize' => array('ret')
				));
			}
	}	
}
