﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Configuration;
using System.IO;
using cosicomodo.quantycaReference;

namespace cosifacile
{
    /// <summary>
    /// Logica di interazione per MainPage.xaml
    /// </summary>
    public partial class MainPage : Window
    {
        string LogName = DateTime.Now.ToString("yyyyMMdd");
        public ServiceLayer sl = new ServiceLayer();
        public RetailPoint rp = new RetailPoint();
        public getOrdersOutputType publicOrders = new getOrdersOutputType();
        public bool multiorder = false;

        public MainPage()
        {
            InitializeComponent();
            logMsg("");
            logMsg("------------------");
            logMsg("Inizializzazione totem");
            try
            {
                rp = sl.getRetailPoint(ConfigurationManager.AppSettings["retailPointID"].ToString());

                logMsg("Servizio GetOrder: " + rp.settings.urlGetOrder);
                logMsg("Servizio PickOrder: " + rp.settings.urlPickOrder);
            }
            catch (Exception ex)
            {
                logMsg("Problema di rete");
                logError(ex);
                MessageBox.Show("Problema di rete, impossibile inizializzare il totem");
                System.Environment.Exit(-1);
            }
            string fs = ConfigurationManager.AppSettings["FullScreenMode"];
            if (fs == "On")
            {
                this.WindowState = WindowState.Maximized;
                this.WindowStyle = System.Windows.WindowStyle.None;
                string tb = ConfigurationManager.AppSettings["TaskBarShow"];
                if (tb != "On")
                {
                    this.Left = 0;
                    this.Top = 0;
                    this.Width = SystemParameters.VirtualScreenWidth;
                    this.Height = SystemParameters.VirtualScreenHeight;
                    this.Topmost = true;
                }
            }
            CosiComodo sp = new CosiComodo();
            this.Content = sp;

        }

        public void logError(Exception ex)
        {
            try
            {
                string logPath = string.Format(ConfigurationManager.AppSettings["LogName"], LogName);

                using (StreamWriter w = File.AppendText(logPath))
                {
                    w.WriteLine(ex.Message);
                    w.WriteLine(ex.StackTrace);
                    w.WriteLine("-------------------------");
                }
            }
            catch { }
        }

        public void logMsg(string msg)
        {
            try
            {
                string logPath = string.Format(ConfigurationManager.AppSettings["LogName"], LogName);
                using (StreamWriter w = File.AppendText(logPath))
                {
                    w.WriteLine(DateTime.Now.ToString() + ": " + msg);
                }

            }
            catch { }
        }

    }
}
