﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using cosicomodo.quantycaReference;

namespace cosifacile
{
    /// <summary>
    /// Logica di interazione per ordersElement.xaml
    /// </summary>
    public partial class ordersElement : UserControl
    {
        public int totHeight;

        public ordersElement()
        {
            InitializeComponent();
        }

        public ordersElement(sezioniOrdineType order, bool isOrderOk)
        {
            InitializeComponent();
            string formatString = "yyyyMMddHHmmss";

            //if (order.testata.ordineBase.statoOrdine != "PRONTO_PER_IL_RITIRO" || (order.testata.ordineBase.statoOrdine != "SLOT_MANCATO")
            if (!isOrderOk)

            {
                grdStato.Background = (SolidColorBrush)(new BrushConverter().ConvertFrom("#FFB700"));
                    lblStato.Text = "SOSTITUZIONI / NON TROVATI\n(SCOPRI TUTTI)";
                int nf = 0;
                int sub = 0;
                foreach (articoloOrdineType currentOrder in order.dettaglio)
                {
                    //if (!Boolean.Equals(currentOrder.articoloSostituzioni, null))
                    if (currentOrder.articoloSostituzioni.flagSostituito)
                    {
                        substituteElement li = new substituteElement(currentOrder);
                        li.Margin = new Thickness(0, 150 * sub, 0, 0);
                        li.VerticalAlignment = System.Windows.VerticalAlignment.Top;
                        subPanel.Children.Add(li);
                        subPanel.Height += 150;
                        sub++;
                    }
                    if (currentOrder.articoloBase.quantita == 0)
                    {
                        notFoundElement li = new notFoundElement(currentOrder);
                        li.Margin = new Thickness(0, 150 * nf, 0, 0);
                        li.VerticalAlignment = System.Windows.VerticalAlignment.Top;
                        nfPanel.Children.Add(li);
                        nfPanel.Height += 150;
                        nf++;
                    }
                }
                int grdHeight = 200 + (nf > sub ? 150 * nf : 150 * sub) + (nf + sub > 0 ? 100 : 0);
                if (sub == 0)
                {
                    colNf.Width = new GridLength(942);
                    grdDetails.ColumnDefinitions.Clear();
                    grdDetails.ColumnDefinitions.Add(new ColumnDefinition());
                    grdDetails.ColumnDefinitions[0].Width = new GridLength(942);
                    grdHeadNf.Width = 942;
                    Grid.SetColumn(grdHeadNf, 0);

                    //Grid.SetColumnSpan(grdHeadNf, 2);
                    subPanel.Visibility = System.Windows.Visibility.Hidden;
                    grdHeadSub.Visibility = System.Windows.Visibility.Hidden;
                }
                else
                {
                    nfPanel.Visibility = System.Windows.Visibility.Hidden;
                }
                if (nf == 0)
                {
                    colSub.Width = new GridLength(942);
                    grdDetails.ColumnDefinitions.Clear();
                    grdDetails.ColumnDefinitions.Add(new ColumnDefinition());
                    grdDetails.ColumnDefinitions[0].Width = new GridLength(942);
                    grdHeadSub.Width = 942;
                    Grid.SetColumn(grdHeadSub, 0);
                    grdHeadSub.Background = (SolidColorBrush)(new BrushConverter().ConvertFrom("#FFB700"));
                    nfPanel.Visibility = System.Windows.Visibility.Hidden;
                    grdHeadNf.Visibility = System.Windows.Visibility.Hidden;
                }
                totHeight = grdHeight;
                grdElement.Height = grdHeight;
                elementDetails.Visibility = System.Windows.Visibility.Hidden;
            }
            else
            {
                lblStato.Text = "DISPONIBILE";
            }
            lblNumero.Content = order.testata.ordineBase.idOrdineUtente;

            DateTime dataOrdine = DateTime.ParseExact(order.testata.ordineBase.dataOrdine, formatString, null);

            lblData.Content = dataOrdine.ToString("dd/MM/yyyy");

            DateTime dataConsegna = DateTime.ParseExact(order.testata.slotPrenotazione.dataConsegna, formatString, null);

            lblOrario.Content = dataConsegna.ToString("HH:mm");
            //lblStato.Content = "PRONTO PER IL RITIRO";// order.testata.ordineBase.statoOrdine;
            lblTotale.Content = order.testata.ordineBase.importoTotale + " €";

        }

        private void grdHeadNf_MouseUp(object sender, MouseButtonEventArgs e)
        {
            nfPanel.Visibility = System.Windows.Visibility.Visible;
            subPanel.Visibility = System.Windows.Visibility.Hidden;
            grdHeadNf.Background = (SolidColorBrush)(new BrushConverter().ConvertFrom("#FFB700"));
            grdHeadSub.Background = (SolidColorBrush)(new BrushConverter().ConvertFrom("#5C3800"));
        }

        private void grdHeadSub_MouseUp(object sender, MouseButtonEventArgs e)
        {
            nfPanel.Visibility = System.Windows.Visibility.Hidden;
            subPanel.Visibility = System.Windows.Visibility.Visible;
            grdHeadSub.Background = (SolidColorBrush)(new BrushConverter().ConvertFrom("#FFB700"));
            grdHeadNf.Background = (SolidColorBrush)(new BrushConverter().ConvertFrom("#5C3800"));
        }

        private void UserControl_Loaded(object sender, RoutedEventArgs e)
        {
            int ttotHeight = Convert.ToInt32(this.grdElement.Height);
        }
    }
}
