﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Configuration;
using System.Windows.Threading;
using cosicomodo.quantycaReference;

namespace cosifacile
{
    /// <summary>
    /// Logica di interazione per OrderDetails.xaml
    /// </summary>
    public partial class OrderDetails : Page
    {
        MainPage parentWindow;
        public ServiceLayer sl = new ServiceLayer();
        DispatcherTimer timer = new DispatcherTimer();
        static int cTimerSec;
        bool sostituiti = false;
        bool indisponibili = false;

        public OrderDetails()
        {
            InitializeComponent();
            UIElement parent = App.Current.MainWindow;
            parentWindow = (MainPage)parent;
            parent = null;
        }

        public OrderDetails(getOrdersOutputType oDetails)
        {
            InitializeComponent();
            UIElement parent = App.Current.MainWindow;
            parentWindow = (MainPage)parent;
            parent = null;
            bool notfound = false;
            bool substitute = false;
            //UIElementCollection notFound = new UIElementCollection(
            try
            {
                foreach (sezioniOrdineType current in oDetails.ordini)
                {
                    int i = 0;


                    foreach (articoloOrdineType order in current.dettaglio)
                    {
                        if (order.articoloBase.SKU == "25500")
                        {
                            order.articoloSostituzioni.flagSostituito = true;
                        }
                        
                        if (Boolean.Equals(order.articoloSostituzioni, null))
                        {
                            // La lista non interessa
                            /*
                            listElement li = new listElement();
                            li.txtQuantity.Content = order.articoloBase.quantita.ToString();
                            li.txtProduct.Text = order.articoloEsteso.descrizioneArticolo;
                            string imgUrl = @"http://localhost:8080/cosicomodo/img/users/75341c020fd806c78f07dd5ec18f7e1a/promos/1.jpg";
                            li.imgProduct.Source = new BitmapImage(new Uri(imgUrl));
                            li.txtTot.Content = order.articoloEsteso.importoLordoTotale.ToString();

                            Grid promoG = new Grid();
                            //promoG.
                            promoG.Height = 300;
                            promoG.Width = 200;
                            promoG.Name = order.articoloBase.idRigaOrdine;
                            promoG.Uid = order.articoloBase.idRigaOrdine;
                            Label l = new Label();
                            l.Content = order.articoloEsteso.descrizioneArticolo;
                            l.FontSize = 36;
                            l.HorizontalAlignment = System.Windows.HorizontalAlignment.Center;
                            l.VerticalAlignment = System.Windows.VerticalAlignment.Center;
                            promoG.HorizontalAlignment = System.Windows.HorizontalAlignment.Left;
                            promoG.Margin = new Thickness(0, 0, 0, 0);
                            Border b = new Border();
                            b.BorderThickness = new Thickness(2);
                            b.BorderBrush = new SolidColorBrush(Colors.White);
                            promoG.Children.Add(b);
                            promoG.Children.Add(l);
                            itemPanel.Children.Add(promoG);
                            //promoG.MouseUp += new MouseButtonEventHandler(promoClick);
                            Grid.SetRow(promoG, 1);
                            Grid.SetColumn(promoG, i);

                            itemPanel.Children.Add(li);
                            */
                        }
                        else
                        {
                            if (order.articoloSostituzioni.skuArticoloOriginale == "25501")
                            {
                                order.articoloSostituzioni.flagSostituito = true;
                            }

                            if (order.articoloSostituzioni.flagSostituito)
                            {
                                substitute = true;
                                listElement li = new listElement();
                                li.txtQuantity.Content = order.articoloBase.quantita.ToString();
                                li.txtProduct.Text = order.articoloEsteso.descrizioneArticolo;
                                string imgUrl = @"http://localhost:8080/cosicomodo/img/users/75341c020fd806c78f07dd5ec18f7e1a/promos/1.jpg";
                                li.imgProduct.Source = new BitmapImage(new Uri(imgUrl));
                                li.txtTot.Content = order.articoloEsteso.importoLordoTotale.ToString();
                                substitutePanel.Children.Add(li);
                            }
                            else
                            {
                                notfound = true;
                                listElement li = new listElement();
                                li.txtQuantity.Content = order.articoloBase.quantita.ToString();
                                li.txtProduct.Text = order.articoloEsteso.descrizioneArticolo;
                                string imgUrl = @"http://localhost:8080/cosicomodo/img/users/75341c020fd806c78f07dd5ec18f7e1a/promos/1.jpg";
                                li.imgProduct.Source = new BitmapImage(new Uri(imgUrl));
                                li.txtTot.Content = order.articoloEsteso.importoLordoTotale.ToString();
                                notFoundPanel.Children.Add(li);
                            }
                        }
                        i++;
                        string ciao = order.articoloBase.idRigaOrdine;
                    }
                    if (!substitute && !notfound) // chiamo direttamente il servizio di delivery
                    {

                    }
                    else
                    {
                        double tabWidth = grdTab.Width;
                        if (substitute)
                        {
                            // aggiungo il tab substitute
                            if (notfound)
                            {
                                itemScroller.VerticalScrollBarVisibility = ScrollBarVisibility.Auto;
                            }
                            else
                            {
                                tabSubstituted.Width = grdTab.Width;
                                tabNotfound.Visibility = System.Windows.Visibility.Hidden;
                            }
                            substitutePanel.Visibility = System.Windows.Visibility.Visible;
                            notFoundPanel.Visibility = System.Windows.Visibility.Hidden;
                        }
                        else
                        {
                            if (notfound)
                            {
                                tabNotfound.Width = grdTab.Width;
                                tabSubstituted.Visibility = System.Windows.Visibility.Hidden;
                                substitutePanel.Visibility = System.Windows.Visibility.Hidden;
                                notFoundPanel.Visibility = System.Windows.Visibility.Visible;
                            }
                        }
                    }
                }
            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void notfound_MouseUp(object sender, MouseButtonEventArgs e)
        {
            notFoundPanel.Visibility = System.Windows.Visibility.Visible;
            substitutePanel.Visibility = System.Windows.Visibility.Hidden;
        }

        private void substituted_MouseUp(object sender, MouseButtonEventArgs e)
        {
            notFoundPanel.Visibility = System.Windows.Visibility.Hidden;
            substitutePanel.Visibility = System.Windows.Visibility.Visible;
        }

        private void TimerTick(object sender, EventArgs e)
        {
            try
            {
                //parentWindow.logMsg("DatiScontrino - TimerTick");
                cTimerSec -= 1;
                if (cTimerSec <= 0)
                {
                    timer.Stop();
                    CosiComodo SUB = new CosiComodo();
                    parentWindow.Content = SUB;
                    parentWindow = null;
                    SUB = null;
                }

                else
                    lblTimer.Content = cTimerSec.ToString();
            }

            catch { }
        }

        private void Page_Loaded(object sender, RoutedEventArgs e)
        {
            cTimerSec = Convert.ToInt32(ConfigurationManager.AppSettings["timerOrder"]);
            timer = new DispatcherTimer();
            timer.Interval = TimeSpan.FromSeconds(1);// TimeSpan.FromSeconds(Convert.ToInt32(ConfigurationManager.AppSettings["timerDaGiocaAHome"]));
            timer.Tick += TimerTick;
            timer.Start();
        }

        private void Page_Unloaded(object sender, RoutedEventArgs e)
        {
            timer.Stop();
        }
        private void btnEsci_Click(object sender, RoutedEventArgs e)
        {
            parentWindow.logMsg("Click sul bottone di lettura");
            //Registrazione SUB = new Registrazione();
            CosiComodo SUB = new CosiComodo();
            parentWindow.Content = SUB;
            parentWindow = null;
            SUB = null;
        }

        private void lblSostituted_MouseUp(object sender, MouseButtonEventArgs e)
        {
            notFoundPanel.Visibility = System.Windows.Visibility.Hidden;
            substitutePanel.Visibility = System.Windows.Visibility.Visible;
            tabSubstituted.Background = new SolidColorBrush(Colors.DarkGreen);
            tabNotfound.Background = new SolidColorBrush(Colors.Gainsboro);
        }

        private void lblNotfound_MouseUp(object sender, MouseButtonEventArgs e)
        {
            notFoundPanel.Visibility = System.Windows.Visibility.Visible;
            substitutePanel.Visibility = System.Windows.Visibility.Hidden;
            tabNotfound.Background = new SolidColorBrush(Colors.DarkGreen);
            tabSubstituted.Background = new SolidColorBrush(Colors.Gainsboro);
        }
    }
}
