﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Configuration;
using System.Windows.Threading;
using cosicomodo.quantycaReference;
using System.Drawing;
using System.Net;
using System.IO;

namespace cosifacile
{
    /// <summary>
    /// Logica di interazione per CosiComodo.xaml
    /// </summary>
    public partial class CosiComodo : Page
    {
        MainPage parentWindow;
        public ServiceLayer sl = new ServiceLayer();

        DispatcherTimer timerPromo = new DispatcherTimer();
        static int cTimerSec;
        private int cTimer;
        static int currentPromoId;
        RetailPoint rp = new RetailPoint();
        string currPromo = "";

        public CosiComodo()
        {
            InitializeComponent();
            UIElement parent = App.Current.MainWindow;
            parentWindow = (MainPage)parent;
            parent = null;
            parentWindow.logMsg("Home_Loaded");
            rp = parentWindow.rp;
            parentWindow.publicOrders = new getOrdersOutputType();
            parentWindow.multiorder = false;
            imgRP.Source = rp.signImg;

            imgRP.Width = rp.signWidth;
            lblRetail.Content = rp.rpText;
            currentPromoId = 0;
            if (rp.rpPromos.Count > 0)
            {
                int promoButtonsWidth = Convert.ToInt32((promoButtons.Width - (2 * (rp.rpPromos.Count - 1))) / rp.rpPromos.Count);

                for (int i = 0; i < rp.rpPromos.Count; i++)
                {
                    Grid promoG = new Grid();
                    if (i == 0)
                    {
                        promoG.Background = (SolidColorBrush)(new BrushConverter().ConvertFrom("#0D553F"));
                        promoG.Margin = new Thickness(0, 0, 0, 0);
                    }
                    else
                    {
                        promoG.Background = (SolidColorBrush)(new BrushConverter().ConvertFrom("#4ea245"));
                        promoG.Margin = new Thickness(((promoButtonsWidth + 2) * i), 0, 0, 0);
                    }
                    //promoG.
                    promoG.Height = promoButtons.Height;
                    promoG.Width = promoButtonsWidth;
                    promoG.Name = "Promo" + i.ToString();
                    promoG.Uid = rp.rpPromos[i].prId.ToString(); ;
                    Label l = new Label();
                    l.Content = rp.rpPromos[i].prName;
                    l.FontSize = 36;
                    l.FontFamily = new System.Windows.Media.FontFamily("Raleway Semibold");
                    l.Foreground = new SolidColorBrush(Colors.White);
                    l.HorizontalAlignment = System.Windows.HorizontalAlignment.Center;
                    l.VerticalAlignment = System.Windows.VerticalAlignment.Center;
                    promoG.HorizontalAlignment = System.Windows.HorizontalAlignment.Left;
                    //promoG.Margin = new Thickness((promoButtonsWidth * i), 0, 0, 0);
                    promoG.Children.Add(l);
                    promoButtons.Children.Add(promoG);
                    //promoG.MouseUp += new MouseButtonEventHandler(promoClick);
                    Grid.SetRow(promoG, 1);
                    Grid.SetColumn(promoG, i);
                }

                var uriSource = new Uri(rp.rpPromos[0].prImgPath);
                imgPromo.Source = new BitmapImage(uriSource);
//                imgPromo.Width = 300;
//                imgPromo.Height = 300;
                currPromo = rp.rpPromos[0].prId.ToString();
                cTimerSec = Convert.ToInt32(parentWindow.rp.settings.carouselTimeout);
                cTimer = cTimerSec;
                timerPromo = new DispatcherTimer();
                //timerPromo.Interval = TimeSpan.FromSeconds(cTimerSec);// TimeSpan.FromSeconds(Convert.ToInt32(ConfigurationManager.AppSettings["timerDaGiocaAHome"]));
                timerPromo.Interval = TimeSpan.FromSeconds(1);
                timerPromo.Tick += TimerTick;
                timerPromo.Start();

            }
        }

        private void TimerTick(object sender, EventArgs e)
        {
            if (cTimer < 1)
            {
                currentPromoId++;
                currentPromoId = currentPromoId % rp.rpPromos.Count;
                currPromo = rp.rpPromos[currentPromoId].prId.ToString();
                //parentWindow.logMsg("Questionnaire TimerTick");
                try
                {
                    foreach (UIElement current in promoButtons.Children)
                    {
                        if (current.GetType() == typeof(Grid))
                        {
                            Grid curGrid = (Grid)current;
                            if (curGrid.Uid == currPromo)
                                curGrid.Background = (SolidColorBrush)(new BrushConverter().ConvertFrom("#0D553F"));
                            else
                                curGrid.Background = (SolidColorBrush)(new BrushConverter().ConvertFrom("#4ea245"));
                        }
                    }

//                    var uriSource = new Uri(rp.rpPromos[currentPromoId].prImgPath);
                    imgPromo.Source = rp.rpPromos[currentPromoId].prImg;
                    cTimer = cTimerSec;
                }
                catch { }
            }
            else
                cTimer--;
        }

        private void gtrdRtira_PreviewMouseUp(object sender, MouseButtonEventArgs e)
        {
            timerPromo.Stop();
            parentWindow.logMsg("Click sul bottone di lettura");
            //Registrazione SUB = new Registrazione();
            LeggiCodice SUB = new LeggiCodice();
            parentWindow.Content = SUB;
            parentWindow = null;
            SUB = null;
        }

        private void grdCard_MouseUp(object sender, MouseButtonEventArgs e)
        {
            try
            {
                timerPromo.Stop();
                parentWindow.logMsg("Click sul bottone di lettura");
                //Registrazione SUB = new Registrazione();
                LeggiCodice SUB = new LeggiCodice(readType.Card);
                parentWindow.Content = SUB;
                parentWindow = null;
                SUB = null;
            }
            catch { }
        }

        private void grdOrder_MouseUp(object sender, MouseButtonEventArgs e)
        {
            try
            {
                timerPromo.Stop();
                parentWindow.logMsg("Click sul bottone di lettura");
                //Registrazione SUB = new Registrazione();
                LeggiCodice SUB = new LeggiCodice(readType.Order);
                parentWindow.Content = SUB;
                parentWindow = null;
                SUB = null;
            }
            catch(Exception ex)
            {
                string err = ex.Message;
                err = ex.StackTrace;
            }
        }

        private void imgLogo_MouseUp(object sender, MouseButtonEventArgs e)
        {
            //System.Environment.Exit(-1);
        }

        private void promoGrid_MouseUp(object sender, MouseButtonEventArgs e)
        {
            cTimer = parentWindow.rp.settings.productTimeout;
        }

        private void Page_Loaded(object sender, RoutedEventArgs e)
        {

        }

    }
}
