﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.IO;
using System.IO.Ports;
using System.Configuration;

namespace cosifacile
{
    public class Utils
    {
        string LogName = DateTime.Now.ToString("yyyyMMdd");

        public void logError(Exception ex)
        {
            try
            {
                string logPath = string.Format(ConfigurationManager.AppSettings["LogName"], LogName);
                using (System.IO.StreamWriter file = new System.IO.StreamWriter(logPath, true))
                {
                    file.WriteLine("-------------------------");
                    file.WriteLine(DateTime.Now.ToString() + ": " + ex.Message);
                    file.WriteLine(DateTime.Now.ToString() + ": " + ex.StackTrace);
                    file.WriteLine("-------------------------");
                }
            }
            catch { }
        }

        public void logMsg(string msg)
        {
            try
            {
                string logPath = string.Format(ConfigurationManager.AppSettings["LogName"], LogName);
                using (StreamWriter w = File.AppendText(logPath))
                {
                    w.WriteLine(DateTime.Now.ToString() + ": " + msg);
                }
            }
            catch { }
        }

        public void CloseSerialPort(SerialPort port)
        {
            if (!Boolean.Equals(port, null))
            {
                if (port.IsOpen)
                {
                    port.DiscardOutBuffer();
                    port.DiscardInBuffer();
                    port.Dispose();
                    port.Close();
                }
            }
        }

    }
}
