﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Text.RegularExpressions;
using System.Configuration;
using System.Drawing;
using System.Collections;
using System.Collections.ObjectModel;
using System.Dynamic;
//using System.Web.Script.Serialization;
using System.Reflection;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.IO;
using System.Windows;
using System.Windows.Media.Imaging;
using System.Net;

namespace cosifacile
{

    public class RetailPoint
    {
        public int rpId { get; set; }
        public string rpName { get; set; }
        public List<Promotion> rpPromos { get; set; }
        public string imgPath { get; set; }
        public BitmapImage signImg { get; set; }
        public double signWidth { get; set; }
        public serviceSettings settings { get; set; }
        private Utils ut = new Utils();
        public string closingCards { get; set; }
        public string address { get; set; }
        public string rpText { get; set; }
        public string adCd1 { get; set; }
        public string adCd2 { get; set; }
        public string cli { get; set; }
        public string adAudiofile { get; set; }
        public int modeType { get; set; }

        public RetailPoint()
        {
        }
        //11093
        public RetailPoint(int id, string name, string path)
        {
            this.rpId = id;
            this.rpName = name;
            this.imgPath = path;
            this.rpPromos = new List<Promotion>();
            string imgPath = string.Format(ConfigurationManager.AppSettings["urlSignImg"], path, id.ToString());
            //ut.logMsg(imgPath);
            var uriSource = new Uri(imgPath);
            this.signImg = new BitmapImage(uriSource);

            WebClient wc = new WebClient();
            byte[] originalData = wc.DownloadData(uriSource);

            MemoryStream stream = new MemoryStream(originalData);
            Bitmap Bitmap = new Bitmap(stream);
            this.signWidth = (double)Bitmap.Width;
        }
    }

    public class serviceSettings
    {
        public string urlGetOrder { get; set; }
        public string urlPickOrder { get; set; }
        public string serviceUserName { get; set; }
        public string servicePassword { get; set; }
        public string insegna { get; set; }
        public string socio { get; set; }
        public string sistema { get; set; }
        public int readCodeTimeout { get; set; }
        public int orderTimeout { get; set; }
        public int pickTimeout { get; set; }
        public int carouselTimeout { get; set; }
        public int productTimeout { get; set; }
        public string adUsr { get; set; }
        public string adPwd { get; set; }
        public string adCli { get; set; }

        public serviceSettings()
        {

        }
    }

    public enum readType
    { Order, Card }

    public class Promotion
    {
        public int prId { get; set; }
        public string prName { get; set; }
        public string prImgPath { get; set; }
        public BitmapImage prImg { get; set; }

        public Promotion()
        { }

        public Promotion(int id, string name, string imgPath)
        {
            this.prId = id;
            this.prName = name;
            this.prImgPath = imgPath;
            var uriSource = new Uri(prImgPath);
            prImg = new BitmapImage(uriSource);
        }
    
    }

}
