﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;
//using cosifacile.comodoServices;
using cosicomodo.quantycaReference;
using System.Configuration;

namespace cosifacile
{
    /// <summary>
    /// Logica di interazione per NoService.xaml
    /// </summary>
    public partial class NoService : Page
    {
        MainPage parentWindow;
        public ServiceLayer sl = new ServiceLayer();
        DispatcherTimer timer = new DispatcherTimer();
        static int cTimerSec;

        public NoService()
        {
            InitializeComponent();
            UIElement parent = App.Current.MainWindow;
            parentWindow = (MainPage)parent;
            parent = null;
            imgRP.Source = parentWindow.rp.signImg;

            imgRP.Width = parentWindow.rp.signWidth;
        }

        private void TimerTick(object sender, EventArgs e)
        {
            try
            {
                //parentWindow.logMsg("DatiScontrino - TimerTick");
                cTimerSec -= 1;
                if (cTimerSec <= 0)
                {
                    exitPage();
                }

                else
                    lblTimer.Content = cTimerSec.ToString();
            }

            catch { }
        }

        private void exitPage()
        {
            parentWindow.logMsg("Uscita pagina lettura");
            timer.Stop();
            CosiComodo SUB = new CosiComodo();
            parentWindow.Content = SUB;
            parentWindow = null;
            SUB = null;
        }

        private void Page_Loaded(object sender, RoutedEventArgs e)
        {
            UIElement parent = App.Current.MainWindow;
            parentWindow = (MainPage)parent;
            parent = null;

            cTimerSec = Convert.ToInt32(ConfigurationManager.AppSettings["timerRead"]);
            timer = new DispatcherTimer();
            timer.Interval = TimeSpan.FromSeconds(1);// TimeSpan.FromSeconds(Convert.ToInt32(ConfigurationManager.AppSettings["timerDaGiocaAHome"]));
            timer.Tick += TimerTick;
            timer.Start();
        }

        private void lblBack_MouseUp(object sender, MouseButtonEventArgs e)
        {
            exitPage();
        }

        private void lblAnnulla_MouseUp(object sender, MouseButtonEventArgs e)
        {
            exitPage();
        }

    }
}
