<?php

class Options_Page {

    const options_group_name = 'lm-option-group';

    private $options;
    
    public function __construct(){
        add_action( 'admin_menu', array( $this, 'add_menu') );
        add_action( 'admin_init', array( $this, 'register_settings') );

        $this->options = array(
            array( 
                'name' => 'lm_facebook_url',
                'label' => 'Facebook URL'
            ),
            array( 
                'name' => 'lm_linkedin_url',
                'label' => 'LinkedIn URL'
            )
        );
    }

    public function add_menu() {
        add_options_page( 
            'Leonardo Mannelli Config',
            'Leonardo Mannelli Config',
            'manage_options',
            'leoman-config.php',
            array( $this, 'lm_option_page')
        );
    }
    
    public function register_settings(){
    
        foreach ( $this->options  as $option){
            register_setting( self::options_group_name , $option['name'] );
        }
        
        
    }

    public function lm_option_page(){
        ?>
        <div class="wrap">
            <h1>Opzioni Tema Leonardo Mannelli</h1>
    
            <form method="post" action="options.php">
                <?php 
                settings_fields( 'lm-option-group' );
                do_settings_sections( 'lm-option-group' );
                ?>
    
                <table class="form-table">
                    <?php foreach ($this->options as $option) : ?>
                        <tr valign="top">
                        <th scope="row"><?php echo $option['label'] ?></th>
                        <td><input type="text" size="100" name="<?php echo $option['name'] ?>" value="<?php echo esc_attr( get_option($option['name']) ); ?>" /></td>
                        </tr>
                    <?php endforeach ?>
                    
                </table>
    
                <?php submit_button(); ?>
            </form>
    
        </div>
        <?php
    }


}

new Options_Page();





