<?php 

/**
 * Plugin Name: MyPlugin
 * Description: my plugin description 
 * Version: 1.0.0
 * Author: AIM srl
 * Author URI: www.aimconsulting.it
 * Developer: Zer0Overflow
 * Developer URI: github.com/zerooverflow
 * Text Domain: myplugin-domain
 *
 * WC requires at least: 3.5
 * WC tested up to: 4.9.4
 *
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$wp_ver = explode ( '.', get_bloginfo( 'version' ));

// controllo versione wp 3.5+ :
if ( $wp_ver[0] < 3 && $wp_ver[1] < 5){
	add_action( 'admin_notices', function(){
		?>
	    <div class="notice notice-error is-dismissible">
	        <p><?php _e('Il plugin richiede Wordpress versione 3.5 o superiore ', 'myplugin-domain' ); ?></p>
	    </div>
    <?php
	});
	return;
}


define ('MYPLUGIN_DIRPATH', plugin_dir_path( __FILE__ ));
define ('MYPLUGIN_URL', plugin_dir_url( __FILE__ ) );



class My_Plugin
{
	
	public static function instance()
	{
		static $instance = false;
		if( $instance === false )
		{
			// Late static binding (PHP 5.3+)
			$instance = new static();
		}
		
		return $instance;
	}
	
	public function admin_scripts($hook_suffix){

		wp_enqueue_style( 'myplugin-style', MYPLUGIN_URL . '/assets/css/myplugin.css', array(), '1.0.0' );
		wp_enqueue_script('myplugin-script', MYPLUGIN_URL .'/assets/js/myplugin.js', array('jquery'));
	
	}
	
	public function load_textdomain(){
		//
		load_plugin_textdomain( 'myplugin-domain', false, basename( dirname( __FILE__ ) ) . '/languages' );
	}

	
	private function includes()
	{
		
	}
  
	private function hooks()
	{
		add_action( 'plugins_loaded',  array( $this,'load_textdomain' ) );
	}
	
	private function is_request( $type ) {
		switch ( $type ) {
			case 'admin' :
				return is_admin();
			case 'ajax' :
				return defined( 'DOING_AJAX' );
			case 'cron' :
				return defined( 'DOING_CRON' );
			case 'frontend' :
				return ( ! is_admin() || defined( 'DOING_AJAX' ) ) && ! defined( 'DOING_CRON' );
		}
	}
	
	
	private function __construct()
	{
		$this->includes();
		$this->hooks();
		
	}
	
	private function __clone() {}
	private function __sleep() {}
	private function __wakeup() {}
	
}


function my_plugin(){
	return My_Plugin::instance();
}



my_plugin();
