


import { Component, OnInit } from '@angular/core';
import { HttpClientDataService } from './../../service/http-client-data.service';
import { UtilService } from '../../service/util.service';
import { AuthService } from 'src/app/auth/service/auth.service';
import { ErrorResponse } from '../../auth/interface/error-response';
import { Platform, MenuController } from '@ionic/angular';
import { TranslateService } from '@ngx-translate/core';
import { Router } from  "@angular/router";
import { Notifica } from 'src/app/interface/notifica';
import { NotificheService } from 'src/app/service/notifiche.service';
import { NotificheResponse } from 'src/app/interface/notifiche-response';
import { ArchiviaNotificaResponse } from 'src/app/interface/archivia-notifica-response';
import { environment } from '../../../environments/environment';
import { Cliente } from 'src/app/auth/interface/cliente';
import { Struttura } from 'src/app/interface/struttura';
import { EventsService } from 'src/app/service/events.service';

@Component({
  selector: 'app-notifiche',
  templateUrl: './notifiche.page.html',
  styleUrls: ['./notifiche.page.scss'],
})
export class NotifichePage implements OnInit {

  constructor(
    public menuCtrl: MenuController,
    private utilService:  UtilService,
    public platform: Platform,
    private notificheService: NotificheService,
    public httpClientDataService: HttpClientDataService,
    public translate: TranslateService,
    public router: Router,
    public authService: AuthService,
  ) {
    EventsService.setStartUp();
    this.initPage();
    setTimeout(() => {
      this.loadNotifiche();
    }, 3000);
    this.isClienteLoggato = AuthService.isClienteLoggato;
    this.eventsIdle();
    setTimeout(() => {
      this.refreshNotifiche();
    }, 60000);
  }

  eventsIdle()
  {
    this.translate = this.utilService.translate;
    this.clienti = AuthService.clienti;
    if(EventsService.clienteCambiato)
    {
      this.isClienteLoggato = AuthService.isClienteLoggato;
      this.loadNotifiche();
    }
    setTimeout(() => {
      this.eventsIdle();
    }, environment.eventsTime);
  }

  refreshNotifiche()
  {
    this.loadNotifiche();
    setTimeout(() => {
      this.refreshNotifiche();
    }, 60000);
  }

  ngOnInit() {
  }

  initPage()
  {
    var allegati = new Array();
    this.clienti = AuthService.clienti;
    this.setStrutture();
    this.strSel = {
      denominazione: null,
      id: null
    };
    this.clienteSel = {
      denominazione: null,
      id: null
    };
    this.notificaAttiva = {
      id: null, 
      allegati:allegati,
      titolo: null,
	    contenuto: null,
      checked: false,
      errorText: "",
      archiviato: false,
      haAllegati: false,
      visualizzata: false,
      data: ""
    };
    this.notifica = "lista";
    this.bottoneVisibile = true;
    this.archiviati = false;
    this.notificheSelezionate = new Array();
    this.error = "";
    this.titolo = "";
    this.tipoStruttura = environment.struttura;
  }

  setStrutture() {
    if(UtilService.strutture != null) this.strutture = UtilService.strutture;
    else
    {
      setTimeout(() => {
        this.setStrutture()
      }, 3000)
    }
  }

  clienti: Cliente[];
  strutture: Struttura[];
  notifiche: Notifica[];
  notificaAttiva: Notifica;
  idCliente;
  idSelezionato;
  notifica: string;
  bottoneVisibile: boolean;
  archiviati: boolean;
  titolo: string;
  strSel:Struttura;
  clienteSel:Cliente;

  idSelected: number;
  selection: boolean = false;
  clickCheckbox: boolean = false;

  filename: string = "";
  notificaId;
  notificheSelezionate: Array<number>;
  error: string;
  tipoStruttura: string;
  clienteSelezionato;
  strutturaSelezionata;
  isClienteLoggato: boolean;

  cambiaCliente()
  {
    this.authService.getCliente(this.clienteSelezionato);
    this.clienteSel = this.authService.clienteTrovato;
  }

  cambiaStruttura()
  {
    this.utilService.getStruttura(this.strutturaSelezionata).then(struttura => 
    {
      this.strSel = struttura;
    });
  }

  toggleGroup(id : number)
  {
    if(this.clickCheckbox)
    {
      this.clickCheckbox = false;
      return;
    }
    this.selection = true;
    this.idSelected = id;
    this.hideButtons()
    this.notifiche.forEach(this.toggle, this);
  }

  toggle(notifica: Notifica, index)
  {
    if(notifica.id == this.idSelected)
    {
      if(notifica.checked)  notifica.checked = false;
      else{
        notifica.checked = true;
        this.showButtons();
      }
    }
    else if(notifica.checked) this.showButtons();
  }

  selectItem(id: number) {
    if(this.clickCheckbox)
    {
      this.clickCheckbox = false;
      return;
    }
    this.selection = true;
    this.idSelected = id;
    this.hideButtons()
    this.notifiche.forEach(this.select, this);
  }

  select(notifica: Notifica, index)
  {
    if(notifica.id == this.idSelected)
    {
      notifica.checked = true;
      this.showButtons();
    }
  }

  showButtons()
  {
    var buttons = document.getElementById('buttonsNotifiche');
    buttons.setAttribute("style", "display:block");
  }

  hideButtons()
  {
    var buttons = document.getElementById('buttonsNotifiche');
    if(buttons != null) buttons.setAttribute("style", "display:none");
  }

  cercaNotifiche()
  {
    this.loadNotifiche();
  }

  getFile(url, nomeFile)
  {
    var fileUrl = this.httpClientDataService.BASE_ADDRESS+url;
    this.utilService.shareDocumento(fileUrl, nomeFile);
  }

  async loadNotifiche()
  {
    this.hideButtons();
    var titolo = null;
    //this.utilService.showLoading();
    AuthService.idReferente = await this.authService.getId();
    if(AuthService.idReferente == null) return;
    let referente = AuthService.idReferente;
    if(this.titolo != null && this.titolo != "") titolo = this.titolo;
    this.notificheService.getListaNotifiche(this.clienteSelezionato, referente, this.archiviati, titolo, this.tipoStruttura, this.strutturaSelezionata).subscribe((res: NotificheResponse)=>{ 
      //this.utilService.closeLoading();
        if(res.error){
          this.utilService.presentAlert("Errore", "", res.error, ["OK"]);
        }
        else 
        {
          this.notifiche = res.notifiche;
          if(this.notifiche != null && this.notifiche.length > 0) this.notificaAttiva = this.notifiche[0];
        }
      },
      (error: ErrorResponse) => {
        //this.utilService.closeLoading();
        var text = "Errore durante la procedura di richiesta Topic";
        this.utilService.stampaErrore(text, error);
      }
    );
  }

  apriLista()
  {
    this.notifica = "lista";
  }

  apriNotifica(id)
  {
    this.idSelezionato = id;
    this.notifiche.forEach(this.setNotifica, this);
  }

  async setNotifica(notifica, index)
  {
    if(notifica.id == this.idSelezionato)
    { 
      this.notificaAttiva = notifica;
      this.notifica = "dettaglio";
      var idReferente = await this.utilService.getIdUser();
      this.notificheService.resetNotifiche(idReferente, environment.struttura, notifica.id).subscribe((res: Boolean)=>{});
      setTimeout(() => {
        this.loadNotifiche();
      }, 5000);
    }
  }

  trackByDoc(index: number, notifica: Notifica): number { return notifica.id; }
  
  checkSelected(id)
  {
    this.clickCheckbox = true;
    this.notificaId = id;
    this.hideButtons()
    this.notifiche.forEach(this.check, this);
  }

  check(richiesta: Notifica, index)
  {
    if(richiesta.checked && richiesta.id != this.notificaId) this.showButtons();
    if(!richiesta.checked && richiesta.id == this.notificaId) this.showButtons();
  }

  archiviaNotifiche(archiviare: boolean)
  {
    this.utilService.showLoading();
    this.notificheSelezionate = new Array();
    this.notifiche.forEach(this.raccogliNotifiche, this);
    this.notificheService.archiviaNotifiche(-1, archiviare, this.notificheSelezionate).subscribe((res: ArchiviaNotificaResponse)=>{
      this.utilService.closeLoading();
      if(res.error){
        this.utilService.presentAlert("Errore", "", res.error, ["OK"]);
      }
      else 
      {
        if(res.notificheNonArchiviate.length > 0)
        {
          this.error = "Questa è la lista degli errori:\r\n"
          res.notificheNonArchiviate.forEach(this.getErrori, this);
          this.utilService.presentAlert("Errore", "", this.error, ["OK"]);
        }
        else{
          this.hideButtons();
          this.loadNotifiche();
          this.apriLista();
        }
      }
    },
    (error: ErrorResponse) => {
      this.utilService.closeLoading();
      var text = "Errore durante l'archiviazione del parere";
      this.utilService.stampaErrore(text, error);
    });
  }

  getErrori(errore: Notifica, index)
  {
    this.error = "Notifica n° " + errore.id + ":" + errore.errorText;
  }

  raccogliNotifiche(notifica: Notifica, index)
  {
    if(notifica.checked) this.notificheSelezionate.push(notifica.id);
  }

  back()
  {
    
    UtilService.titoloPagina = '';
    this.router.navigateByUrl('home/index');
  }

  logout(){
    this.utilService.logout();
  }

}
