import { Component, OnInit } from '@angular/core';
import { UtilService } from 'src/app/service/util.service';
import { Events, Platform } from '@ionic/angular';
import { Router } from '@angular/router';
import { AuthService } from 'src/app/auth/service/auth.service';
import { TranslateService } from '@ngx-translate/core';
import { Corso } from 'src/app/interface/corso';
import { CorsiResponse } from 'src/app/interface/corsi-response';
import { CorsiRequest } from 'src/app/interface/corsi-request';
import { ErrorResponse } from 'src/app/auth/interface/error-response';
import { CorsiService } from 'src/app/service/corsi.service';
import { IscrizioneCorsoResponse } from 'src/app/interface/iscrizione-corso-response';

@Component({
  selector: 'app-calendario-corsi',
  templateUrl: './calendario-corsi.page.html',
  styleUrls: ['./calendario-corsi.page.scss'],
})
export class CalendarioCorsiPage implements OnInit {
  
  inizializzaCalendarioCorsi() {
    this.calendarioCorsi = {
      request: null,
      error: "",
      corsi: null
    };
  }

  constructor(
    public events: Events,
    private  router:  Router,
    private  utilService: UtilService,
    public translate: TranslateService,
    public platform: Platform,
    private corsiService: CorsiService
  ) 
  { 
    this.date1 = "";
    this.date2 = "";
    this.events.publish('functionCall:startup', null);
    if(AuthService.clienteSelezionato.id != null) this.getCorsi();
    this.events.subscribe('functionCall:clienteCambiato', eventData => { 
      this.getCorsi();
    });
    this.events.subscribe('functionCall:linguaCambiata', eventData => {
      translate = utilService.translate;
    });
    translate = utilService.translate;
    this.inizializzaCalendarioCorsi();
  }

  date1;
  date2;
  calendarioCorsi : CorsiResponse;
  titolo: string;

  ngOnInit() {
  }

  iscriviti(id: number)
  {
    this.utilService.showLoading();
    var referente = AuthService.idReferente;
    this.corsiService.iscriviti(referente, id).subscribe((res: IscrizioneCorsoResponse)=>{ 
      this.utilService.closeLoading();
      if(res.error){
        this.utilService.presentAlert("Errore", "", res.error, ["OK"]);
      }
      else 
      {
        if(res.riuscita) this.utilService.stampaSuccesso("Iscrizione al corso avvenuta con successo!");
        else this.utilService.stampaAvviso("Iscrizione al corso non riuscita, probabilmente il corso è pieno");
      }
      this.getCorsi();
    },
    (error: ErrorResponse) => {
      this.utilService.closeLoading();
      var text = "Errore durante la procedura di richiesta di Iscrizione al Corso";
      this.utilService.stampaErrore(text, error);
      this.getCorsi();
    });
  }

  getCorsi() {
    this.utilService.showLoading();
    var dataA = null;
    var dataDa = null;
    var tit = null;
    if(this.titolo != "") tit = this.titolo;
    if(this.date1 != null  && this.date1 != "") dataDa = this.utilService.dateFormatConvert(this.date1);
    if(this.date2 != null  && this.date2 != "") dataA = this.utilService.dateFormatConvert(this.date2);
    var request: CorsiRequest;
    var referente = AuthService.idReferente;
    request = this.corsiService.createRequest(parseInt(referente),tit,dataDa, dataA, false);
    this.corsiService.getCorsi(request).subscribe((res: CorsiResponse)=>{
      this.utilService.closeLoading();
      if(res.error){
        this.utilService.presentAlert("Errore", "", res.error, ["OK"]);
      }
      else 
      {
        this.calendarioCorsi = res;
      }
    },
    (error: ErrorResponse) => {
      this.utilService.closeLoading();
      var text = "Errore durante la richiesta di corsi a cui iscriversi";
      this.utilService.stampaErrore(text, error);
    });
  }

  back()
  {
    
    UtilService.titoloPagina = '';
    this.events.publish('functionCall:cambiaTitolo', null);
    this.router.navigateByUrl('home/index');
  }

  resetDate()
  {
    this.date1 = "";
    this.date2 = "";
  }

  trackByDoc(index: number, corso: Corso): number { return corso.id; }

}
