import { Injectable } from '@angular/core';
import { HttpHeaders} from  '@angular/common/http';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class HttpClientDataService {

  constructor() { 
    this.BASE_ADDRESS = environment.BASE_ADDRESS;
    this.P2PSingleSignOnUrl = environment.P2PSingleSignOnUrl;
    this.P2PTokenUrl = environment.P2PTokenUrl;
  }

  BASE_ADDRESS:  string  =  '';

  P2PTokenUrl: string = "";

  P2PSingleSignOnUrl: string = "";

  httpFormData = {
    headers: new HttpHeaders({
      'Content-Type':  'multipart/form-data'
    })
  };

  httpOptions = {
    headers: new HttpHeaders({
      'Content-Type':  'application/x-www-form-urlencoded'
    })
  };

  httpOptionsJson = {
    headers: new HttpHeaders({
      'Content-Type':  'application/json'
    })
  };

}
