import { Component, OnInit } from '@angular/core';
import { Platform } from '@ionic/angular';
import { UtilService } from '../../service/util.service';
import { TranslateService } from '@ngx-translate/core';
import { Struttura } from 'src/app/interface/struttura';
import { environment } from '../../../environments/environment';
import { EventsService } from 'src/app/service/events.service';

@Component({
  selector: 'app-index',
  templateUrl: './index.page.html',
  styleUrls: ['./index.page.scss'],
})
export class IndexPage implements OnInit {

  constructor( 
    public platform: Platform,
    private utilService: UtilService, 
    public translate: TranslateService) {
    EventsService.setStartUp();
    this.eventsIdle();
    
    this.setStrutture();
    this.strutturaSelected();
  }

  eventsIdle()
  {
    this.translate = this.utilService.translate;
    if(EventsService.strutturaSelected || EventsService.strutturaSelectedHome) this.strutturaSelected();
    if(EventsService.updateStrutture) this.setStrutture();
    setTimeout(() => {
      this.eventsIdle();
    }, environment.eventsTime);
  }

  idStrutturaSel:number;
  consulting: Struttura;
  coaching: Struttura;
  training: Struttura;
  strutturaName;

  strutturaSelected()
  {
    var struttutaSel = this.utilService.getStrutturaSel();
    if(struttutaSel != null) this.idStrutturaSel = struttutaSel.id;
    else this.idStrutturaSel = 0;
    this.strutturaName = this.utilService.getStrutturaName();
  }

  isconsultingSelected():boolean
  {
    return (this.consulting != null && this.idStrutturaSel == this.consulting.id) || this.strutturaName == "consulting";
  }

  iscoachingSelected():boolean
  {
    return (this.coaching != null && this.idStrutturaSel == this.coaching.id) || this.strutturaName == "coaching";
  }

  istrainingSelected():boolean
  {
    return (this.training != null && this.idStrutturaSel == this.training.id) || this.strutturaName == "training";
  }

  setStrutture()
  {
    this.utilService.getStruttura(environment.ConsultingId).then(struttura => 
    {
      this.consulting = struttura;
    });
    this.utilService.getStruttura(environment.CoachingId).then(struttura => 
    {
      this.coaching = struttura;
    });
    this.utilService.getStruttura(environment.TrainingId).then(struttura => 
    {
      this.training = struttura;
    });
  }

  apriPagina(pagina:string)
  {
    this.utilService.apriPagina(pagina);
  }

  ngOnInit() {}

}
