import { Injectable } from '@angular/core';
import { CorsiRequest } from '../interface/corsi-request';
import { Pair } from '../interface/pair';
import { HttpClient, HttpErrorResponse } from '@angular/common/http';
import { CorsiResponse } from '../interface/corsi-response';
import { HttpClientDataService } from './http-client-data.service';
import { tap, catchError } from  'rxjs/operators';
import { ErrorResponse } from '../auth/interface/error-response';
import { of, Observable } from 'rxjs';
import { IscrizioneCorsoResponse } from '../interface/iscrizione-corso-response';
import { IscrizioneCorsoRequest } from '../interface/iscrizione-corso-request';

@Injectable({
  providedIn: 'root'
})
export class CorsiService {

  constructor(private  httpClient: HttpClient, private  httpClientDataService: HttpClientDataService) {
    this.errorRespose = { 
      error: true,
      errorMsg: ""
    };
   }

  iscriviti(referente: string, corso: number) : Observable<IscrizioneCorsoResponse>{
    var request = this.createIscrizioneRequest(parseInt(referente),corso);
    var param = this.encodeBodyIscrizione(request);
    return this.httpClient.post<IscrizioneCorsoResponse>(this.httpClientDataService.BASE_ADDRESS+'/intranet/iscrizioneCorso.do', param, this.httpClientDataService.httpOptionsJson)
      .pipe(
      catchError(this.handleError),
      tap( (res:  IscrizioneCorsoResponse ) => {

        if (!res.error) {
          this.errorRespose.error = false;
          return res;
        }
        else{
          this.errorRespose.error = true;
          this.errorRespose.errorMsg = res.error;          
        }
      })
    );
  }

  encodeBodyIscrizione(params: IscrizioneCorsoRequest) {
    var request = "{\"referente\" : "+params.referente+",\"corso\" : "+params.corso+"}}";
    return request;
  }

  createIscrizioneRequest(referente: number, corso: number) {
    var request:IscrizioneCorsoRequest;

    request = {
      referente: referente,
      corso: corso
    };

    return request;

  }

  getCorsi(request: CorsiRequest) : Observable<CorsiResponse>{
    var param = this.encodeBodyCorsi(request);
    return this.httpClient.post<CorsiResponse>(this.httpClientDataService.BASE_ADDRESS+'/intranet/corsi.do', param, this.httpClientDataService.httpOptionsJson)
      .pipe(
      catchError(this.handleError),
      tap( (res:  CorsiResponse ) => {

        if (!res.error) {
          this.errorRespose.error = false;
          return res;
        }
        else{
          this.errorRespose.error = true;
          this.errorRespose.errorMsg = res.error;          
        }
      })
    );
  }

  encodeBodyCorsi(params: CorsiRequest) {
    var request = "{\"referente\" : "+params.referente+",\"limite\" : "+params.limite+
                  ",\"iscritto\" : "+params.iscritto+",\"filtri\" : {";
    var filtro;
    var first = true;
    var i;
    for (i = 0; i < params.filtri.length; i++) {
      filtro = params.filtri[i];
      if(first) first = false;
      else request += ", ";
      if(filtro.type == "int")
        request += "\""+filtro.key + "\":"+filtro.value;
      else
        request += "\""+filtro.key + "\":\""+filtro.value+"\"";
    }
    request += "}}";
    return request;
  }

  createRequest(id: number, titolo: any, daData: any, aData: any, iscritto: boolean): CorsiRequest {
    var request:CorsiRequest;
    var pair:Pair;
    var pairs: Pair[] = new Array();

    if(titolo != null)
    {
      pair = {
        key: "titolo",
        value: titolo,
        type: "string"
      }
      pairs.push(pair);
    }

    if(daData != null)
    {
      pair = {
        key: "daData",
        value: daData,
        type: "string"
      }
      pairs.push(pair);
    }

    if(aData != null)
    {
      pair = {
        key: "aData",
        value: aData,
        type: "string"
      }
      pairs.push(pair);
    }

    request = {
      referente: id,
      limite: null,
      iscritto: iscritto,
      filtri: pairs
    };

    return request;
  }

  errorRespose: ErrorResponse; 

  handleError(error: HttpErrorResponse) {
    this.errorRespose = { 
      error: true,
      errorMsg: ""
    };
    if (error.error instanceof ErrorEvent) {
      this.errorRespose.errorMsg = error.error.message;
    } else {
      this.errorRespose.errorMsg = error.error;
    }
    return of(this.errorRespose);
  };
}
