import { Component } from '@angular/core';

import { MenuController } from '@ionic/angular';
import { AuthService } from './auth/service/auth.service';
import { Router } from '@angular/router';
import { UtilService } from './service/util.service';
import { Storage } from '@ionic/storage-angular';

@Component({
  selector: 'app-root',
  templateUrl: 'app.component.html'
})
export class AppComponent {
  constructor(
    private router: Router,
    private authService: AuthService,
    private utilService:  UtilService,
    public menuCtrl: MenuController,
    private  storage:  Storage,

  ) {
    this.initializeApp();
  }

  created : boolean = false;

  async initializeApp() {
    if(!this.created)
    {
      await this.storage.create();
      this.created = true;
    }
    this.utilService.loadLingua();
    if(UtilService.isNotificaResume == null) UtilService.isNotificaResume = false;
    this.utilService.initConfig(false, 'notifiche');
  }

  async logout(){
    await this.authService.logout();
    this.router.navigateByUrl('login');
  }

  openSideBar()
  {
    this.menuCtrl.open('mainmenu');
  }

  closeSideMenu() {
    this.menuCtrl.close();
  }
}
