import { Component, OnInit } from '@angular/core';
import { Platform } from '@ionic/angular';
import { TranslateService } from '@ngx-translate/core';
import { AuthService } from 'src/app/auth/service/auth.service';
import { UtilService } from './../../service/util.service';
import { environment } from '../../../environments/environment';
import { Struttura } from 'src/app/interface/struttura';
import { EventsService } from 'src/app/service/events.service';

@Component({
  selector: 'app-preview-home',
  templateUrl: './preview-home.page.html',
  styleUrls: ['./preview-home.page.scss'],
})
export class PreviewHomePage implements OnInit {

  constructor(
    private  utilService: UtilService,
    public platform: Platform,
    public translate: TranslateService,
    public authService:AuthService
  ) 
  { 
    EventsService.setStartUp();
    setTimeout(() => {
      this.eventsIdle();
    }, 1000);
  }

  eventsIdle()
  {
    this.translate = this.utilService.translate;
    if(EventsService.clienteCambiato) this.setStrutture();
    if(EventsService.updateStrutture)
    {
      this.setStrutture();
      if(UtilService.redirectToNotifiche)
      {
        UtilService.redirectToNotifiche = false;
        this.utilService.apriPagina("notifiche");
      }
    }
    setTimeout(() => {
      this.eventsIdle();
    }, environment.eventsTime);
  }

  consulting: Struttura;
  coaching: Struttura;
  training: Struttura;
  name: String;
  pageReady: boolean = false;
  startup: boolean = true;

  setStrutture()
  {
    this.authService.getId();
    this.authService.getName().then(state => {
      this.name = state;
      this.pageReady = true;
    });
    this.utilService.getStruttura(environment.ConsultingId).then(struttura => 
    {
      this.consulting = struttura;
    });
    this.utilService.getStruttura(environment.CoachingId).then(struttura => 
    {
      this.coaching = struttura;
    });
    this.utilService.getStruttura(environment.TrainingId).then(struttura => 
    {
      this.training = struttura;
    });
  }

  ngOnInit() {
  }

  selectStruttura(struttura:String)
  {
    let ok = false;
    switch(struttura)
    {
      case "consulting":
      {
        this.utilService.setStrutturaSel(this.consulting);
        ok = true;
        
        this.utilService.setStrutturaName("consulting");
        break;
      }
      case "training":
      {
        //this.utilService.setStrutturaSel(this.training);
        ok = false;
        
        //this.utilService.setStrutturaName("training");
        break;
      }
      case "coaching":
      {
        //this.utilService.setStrutturaSel(this.coaching);
        ok = false;
        
        //this.utilService.setStrutturaName("coaching");
        break;
      }
    }
    if(ok) EventsService.setStrutturaSelected();
	  else{
      this.utilService.stampaAvviso("Struttura non presente in questo profilo");
    }
  }

}
