import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  { path: '', redirectTo: 'login', pathMatch: 'full' },
  { path: 'home', loadChildren:  () => import('../app/pages/home/home.module').then(m => m.HomePageModule) },
  { path: 'login', loadChildren: () => import('../app/auth/pages/login/login.module').then(m => m.LoginPageModule) },
  { path: 'reset', loadChildren: () => import('../app/auth/pages/reset/reset.module').then(m => m.ResetPageModule) },  
  { path: 'businesscall', loadChildren: () => import('../app/pages/businesscall/businesscall.module').then(m => m.BusinesscallPageModule) },
  { path: 'privacy', loadChildren: () => import('../app/pages/privacy/privacy.module').then(m => m.PrivacyPageModule) },
  { path: 'registrazione', loadChildren: () => import('./auth/pages/registrazione/registrazione.module').then(m => m.RegistrazionePageModule) }




];
@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule {}
