import { Component, OnInit } from '@angular/core';
import { Router } from  "@angular/router";
import { Events } from '@ionic/angular';
import { UtilService } from '../../service/util.service';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'app-index',
  templateUrl: './index.page.html',
  styleUrls: ['./index.page.scss'],
})
export class IndexPage implements OnInit {

  constructor(private  router:  Router, public events: Events, private utilService: UtilService, public translate: TranslateService) {
    this.events.publish('functionCall:startup', null);
    this.events.subscribe('functionCall:linguaCambiata', eventData => {
      translate = utilService.translate;
    });
    translate = utilService.translate;
  }

  apriPagina(pagina:string)
  {
    this.utilService.apriPagina(pagina);
  }

  ngOnInit() {}

}
