import { Pair } from './../interface/pair';
import { DocumentiRequest } from './../interface/documenti-request';
import { HttpClient, HttpErrorResponse } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { UtilService } from '../service/util.service';
import { DocumentiResponse } from '../interface/documenti-response';
import { Observable, of} from  'rxjs';
import { HttpClientDataService } from '../service/http-client-data.service';
import { ErrorResponse } from '../auth/interface/error-response';
import { tap, catchError } from  'rxjs/operators';

@Injectable({
  providedIn: 'root'
})
export class DocumentiService {

  constructor(private  httpClient: HttpClient, private  utilService:  UtilService,
    private  httpClientDataService: HttpClientDataService) {
      this.errorRespose = { 
        error: true,
        errorMsg: ""
      };
  }

  encodeBodyDocumenti(params: DocumentiRequest) {
    var request = "{\"cliente\" : "+params.cliente+",\"limite\" : "+params.limite+",\"filtri\" : {";
    var filtro;
    var first = true;
    var i;
    for (i = 0; i < params.filtri.length; i++) {
      filtro = params.filtri[i];
      if(first) first = false;
      else request += ", ";
      if(filtro.type == "int")
        request += "\""+filtro.key + "\":"+filtro.value;
      else
        request += "\""+filtro.key + "\":\""+filtro.value+"\"";
    }
    request += "}}";
    return request;
  }

  createRequest(id, limite, titolo, tipo, daData, aData): DocumentiRequest
  {
    var request:DocumentiRequest;
    var pair:Pair;
    var pairs: Pair[] = new Array();

    if(titolo != null)
    {
      pair = {
        key: "titolo",
        value: titolo,
        type: "string"
      }
      pairs.push(pair);
    }

    if(tipo != null)
    {
      pair = {
        key: "tipo",
        value: tipo,
        type: "int"
      }
      pairs.push(pair);
    }

    if(daData != null)
    {
      pair = {
        key: "daData",
        value: daData,
        type: "string"
      }
      pairs.push(pair);
    }

    if(aData != null)
    {
      pair = {
        key: "aData",
        value: aData,
        type: "string"
      }
      pairs.push(pair);
    }

    request = {
      cliente: id,
      limite: limite,
      filtri: pairs
    };

    return request;
  }

  createInitialRequest(id): DocumentiRequest
  {
    return this.createRequest(id, 10, null, null, null, null);
  }

  getDocumenti(value: DocumentiRequest): Observable<DocumentiResponse>{

    var param = this.encodeBodyDocumenti(value);
    return this.httpClient.post<DocumentiResponse>(this.httpClientDataService.BASE_ADDRESS+'/intranet/documenti.do', param, this.httpClientDataService.httpOptionsJson)
      .pipe(
      catchError(this.handleError),
      tap( (res:  DocumentiResponse ) => {

        if (!res.error) {
          this.errorRespose.error = false;
          return res;
        }
        else{
          this.errorRespose.error = true;
          this.errorRespose.errorMsg = res.error;          
        }
      })
    );
  }

  errorRespose: ErrorResponse; 

  handleError(error: HttpErrorResponse) {
    this.errorRespose = { 
      error: true,
      errorMsg: ""
    };
    if (error.error instanceof ErrorEvent) {
      this.errorRespose.errorMsg = error.error.message;
    } else {
      this.errorRespose.errorMsg = error.error;
    }
    return of(this.errorRespose);
  };
}