import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  { path: '', redirectTo: 'login', pathMatch: 'full' },
  { path: 'home', loadChildren: '../app/pages/home/home.module#HomePageModule' },
  { path: 'login', loadChildren: '../app/auth/pages/login/login.module#LoginPageModule' },
  { path: 'reset', loadChildren: '../app/auth/pages/reset/reset.module#ResetPageModule' },  
  { path: 'businesscall', loadChildren: '../app/pages/businesscall/businesscall.module#BusinesscallPageModule' },
  { path: 'privacy', loadChildren: '../app/pages/privacy/privacy.module#PrivacyPageModule' }


];
@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule {}
