import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { HomePage } from './home.page';

const routes: Routes = [
  {
    path: '',
    component: HomePage,
    children: [
      {
        path: 'index',
        children: [
          {
            path: '',
            loadChildren: '../index/index.module#IndexPageModule'
          }
        ]
      },
      {
        path: 'bi',
        children: [
          {
            path: '',
            loadChildren: '../bi/bi.module#BiPageModule'
          }
        ]
      },
      {
        path: 'documenti',
        children: [
          {
            path: '',
            loadChildren: '../documenti/documenti.module#DocumentiPageModule'
          }
        ]
      },
      {
        path: 'interviste',
        children: [
          {
            path: '',
            loadChildren: '../interviste/interviste.module#IntervistePageModule'
          }
        ]
      },
      {
        path: 'parere',
        children: [
          {
            path: '',
            loadChildren: '../parere/parere.module#ParerePageModule'
          }
        ]
      },
      {
        path: 'segreteria',
        children: [
          {
            path: '',
            loadChildren: '../segreteria/segreteria.module#SegreteriaPageModule'
          }
        ]
      },
      {
        path: 'change-pwd',
        children: [
          {
            path: '',
            loadChildren: '../../auth/pages/change-pwd/change-pwd.module#ChangePwdPageModule'
          }
        ]
      },
      {
        path: '',
        redirectTo: '/home/index',
        pathMatch: 'full'
      }
    ]
  },
  {
    path: '',
    redirectTo: '/home/index',
    pathMatch: 'full'
  }
];

@NgModule({
  imports: [
    RouterModule.forChild(routes)
  ],
  exports: [RouterModule]
})
export class HomePageRoutingModule {}
