import { Component } from '@angular/core';

import { Platform, MenuController } from '@ionic/angular';
import { SplashScreen } from '@ionic-native/splash-screen/ngx';
import { StatusBar } from '@ionic-native/status-bar/ngx';
import { AuthService } from './auth/service/auth.service';
import { Router } from '@angular/router';
import { AndroidPermissions } from '@ionic-native/android-permissions/ngx';
import { UtilService } from './service/util.service';

@Component({
  selector: 'app-root',
  templateUrl: 'app.component.html'
})
export class AppComponent {
  constructor(
    private platform: Platform,
    private splashScreen: SplashScreen,
    private statusBar: StatusBar,
    private router: Router,
    private authService: AuthService,
    private utilService:  UtilService,
    private androidPermissions: AndroidPermissions,
    public menuCtrl: MenuController

  ) {
    this.initializeApp();
  }

  async initializeApp() {
    this.utilService.loadLingua();
    this.utilService.initConfig(false, 'notifiche');
  }

  async logout(){
    await this.authService.logout();
    this.router.navigateByUrl('login');
  }

  apriPagina(pagina:string)
  {
    switch(pagina)
    {
      case "home":
      {
        this.router.navigateByUrl('index');
        break;
      }
      case "documenti":
      {
        this.router.navigateByUrl('documenti');
        break;
      }
      case "interviste":
      {
        this.router.navigateByUrl('interviste');
        break;
      }
      case "pareri":
      {
        this.router.navigateByUrl('pareri');
        break;
      }
      case "segreteria":
      {
        this.router.navigateByUrl('segreteria');
        break;
      }
      case "change-password":
      {
        this.router.navigateByUrl('change-pwd');
        break;
      }
    }
  }

  openSideBar()
  {
    this.menuCtrl.open('mainmenu');
  }

  closeSideMenu() {
    this.menuCtrl.close();
  }
}
