import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { HomePage } from './home.page';

const routes: Routes = [
  {
    path: '',
    component: HomePage,
    children: [
      { 
        path: 'preview-home', 
        children: [
          {
            path: '',
            loadChildren:() => import('../preview-home/preview-home.module').then(m => m.PreviewHomePageModule) 
          }
        ]
      },
      {
        path: 'index',
        children: [
          {
            path: '',
            loadChildren: () => import('../index/index.module').then(m => m.IndexPageModule)
          }
        ]
      },
      {
        path: 'bi',
        children: [
          {
            path: '',
            loadChildren: () => import('../bi/bi.module').then(m => m.BiPageModule)
          }
        ]
      },
      {
        path: 'documenti',
        children: [
          {
            path: '',
            loadChildren: () => import('../documenti/documenti.module').then(m => m.DocumentiPageModule)
          }
        ]
      },
      {
        path: 'interviste',
        children: [
          {
            path: '',
            loadChildren: () => import('../interviste/interviste.module').then(m => m.IntervistePageModule)
          }
        ]
      },
      {
        path: 'parere',
        children: [
          {
            path: '',
            loadChildren: () => import('../parere/parere.module').then(m => m.ParerePageModule)
          }
        ]
      },
      {
        path: 'segreteria',
        children: [
          {
            path: '',
            loadChildren: () => import('../segreteria/segreteria.module').then(m => m.SegreteriaPageModule)
          }
        ]
      },
      {
        path: 'change-pwd',
        children: [
          {
            path: '',
            loadChildren: () => import('../../auth/pages/change-pwd/change-pwd.module').then(m => m.ChangePwdPageModule)
          }
        ]
      },
      {
        path: 'notifiche',
        children: [
          {
            path: '',
            loadChildren: () => import('../notifiche/notifiche.module').then(m => m.NotifichePageModule)
          }
        ]
      },
      {
        path: '',
        redirectTo: '/home/preview-home',
        pathMatch: 'full'
      }
    ]
  },
  {
    path: '',
    redirectTo: '/home/preview-home',
    pathMatch: 'full'
  }
];

@NgModule({
  imports: [
    RouterModule.forChild(routes)
  ],
  exports: [RouterModule]
})
export class HomePageRoutingModule {}
