import { Component, OnInit } from '@angular/core';
import { Platform,Events } from '@ionic/angular';
import { UtilService } from '../../service/util.service';
import { TranslateService } from '@ngx-translate/core';
import { Struttura } from 'src/app/interface/struttura';
import { environment } from '../../../environments/environment';

@Component({
  selector: 'app-index',
  templateUrl: './index.page.html',
  styleUrls: ['./index.page.scss'],
})
export class IndexPage implements OnInit {

  constructor( 
    public events: Events,
    public platform: Platform,
    private utilService: UtilService, 
    public translate: TranslateService) {
    this.events.publish('functionCall:startup', null);
    this.events.subscribe('functionCall:linguaCambiata', eventData => {
      translate = utilService.translate;
    });
    translate = utilService.translate;

    this.events.subscribe('functionCall:strutturaSelected', eventData => {
      this.strutturaSelected();
    });

    this.events.subscribe('functionCall:strutturaSelectedHome', eventData => {
      this.strutturaSelected();
    });

    this.events.subscribe('functionCall:updateStrutture', eventData => {
      this.setStrutture();
    });
    
    this.setStrutture();
    this.strutturaSelected();
  }

  idStrutturaSel:number;
  consultingService: Struttura;
  mediatoreCreditizio: Struttura;
  realEstateBrokerage: Struttura;

  strutturaSelected()
  {
    var struttutaSel = this.utilService.getStrutturaSel();
    this.idStrutturaSel = struttutaSel.id;
  }

  isServizioSelected():boolean
  {
    return this.consultingService != null && this.idStrutturaSel == this.consultingService.id;
  }

  isCreditiziaSelected():boolean
  {
    return this.mediatoreCreditizio != null && this.idStrutturaSel == this.mediatoreCreditizio.id;
  }

  isImmobiliareSelected():boolean
  {
    return this.realEstateBrokerage != null && this.idStrutturaSel == this.realEstateBrokerage.id;
  }

  setStrutture()
  {
    this.utilService.getStruttura(environment.ConsultingServiceId).then(struttura => 
    {
      this.consultingService = struttura;
    });
    this.utilService.getStruttura(environment.MediatoreCreditizioId).then(struttura => 
    {
      this.mediatoreCreditizio = struttura;
    });
    this.utilService.getStruttura(environment.RealEstateBrokerageId).then(struttura => 
    {
      this.realEstateBrokerage = struttura;
    });
  }

  apriPagina(pagina:string)
  {
    this.utilService.apriPagina(pagina);
  }

  ngOnInit() {}

}
