import { Component, OnInit } from '@angular/core';
import { Platform } from '@ionic/angular';
import { UtilService } from '../../service/util.service';
import { TranslateService } from '@ngx-translate/core';
import { Struttura } from 'src/app/interface/struttura';
import { environment } from '../../../environments/environment';
import { EventsService } from 'src/app/service/events.service';

@Component({
  selector: 'app-index',
  templateUrl: './index.page.html',
  styleUrls: ['./index.page.scss'],
})
export class IndexPage implements OnInit {

  constructor( 
    public platform: Platform,
    private utilService: UtilService, 
    public translate: TranslateService) {
    EventsService.setStartUp();
    this.eventsIdle();
    
    this.setStrutture();
    this.strutturaSelected();
  }

  eventsIdle()
  {
    this.translate = this.utilService.translate;
    setTimeout(() => {
      if(EventsService.strutturaSelected || EventsService.strutturaSelectedHome) this.strutturaSelected();
      if(EventsService.updateStrutture) this.setStrutture();
      this.eventsIdle();
    }, environment.eventsTime);
  }

  idStrutturaSel:number;
  consultingService: Struttura;
  mediatoreCreditizio: Struttura;
  realEstateBrokerage: Struttura;
  strutturaName;

  strutturaSelected()
  {
    var struttutaSel = this.utilService.getStrutturaSel();
    if(struttutaSel != null) this.idStrutturaSel = struttutaSel.id;
    else this.idStrutturaSel = 0;
    this.strutturaName = this.utilService.getStrutturaName();
  }

  isServizioSelected():boolean
  {
    return (this.consultingService != null && this.idStrutturaSel == this.consultingService.id) || this.strutturaName == "consulting";
  }

  isCreditiziaSelected():boolean
  {
    return (this.mediatoreCreditizio != null && this.idStrutturaSel == this.mediatoreCreditizio.id) || this.strutturaName == "creditizio";
  }

  isImmobiliareSelected():boolean
  {
    return (this.realEstateBrokerage != null && this.idStrutturaSel == this.realEstateBrokerage.id) || this.strutturaName == "immobiliare";
  }

  setStrutture()
  {
    this.utilService.getStruttura(environment.ConsultingServiceId).then(struttura => 
    {
      this.consultingService = struttura;
    });
    this.utilService.getStruttura(environment.MediatoreCreditizioId).then(struttura => 
    {
      this.mediatoreCreditizio = struttura;
    });
    this.utilService.getStruttura(environment.RealEstateBrokerageId).then(struttura => 
    {
      this.realEstateBrokerage = struttura;
    });
  }

  apriPagina(pagina:string)
  {
    this.utilService.apriPagina(pagina);
  }

  ngOnInit() {}

}
