import { Cliente } from './../../auth/interface/cliente';
import { Component } from '@angular/core';
import { Router } from  "@angular/router";
import { Events, MenuController } from '@ionic/angular';
import { AuthService } from '../../auth/service/auth.service';
import { UtilService } from '../../service/util.service';
import { Pair } from 'src/app/interface/pair';
import { TranslateService } from '@ngx-translate/core';



@Component({
  selector: 'app-home',
  templateUrl: 'home.page.html',
  styleUrls: ['home.page.scss']
})
export class HomePage {
  constructor(private  authService:  AuthService, private  router:  Router, public events: Events, public menuCtrl: MenuController, private utilService: UtilService, public translate: TranslateService) {
    this.clienti = [];
    this.clienteSelezionato = {
      denominazione: null,
      id: null
    };
    /*this.authService.isLoggedIn().then(state => {
      if (!state) {
        this.router.navigate(['login']);
      }
    });*/
    this.events.subscribe('functionCall:startup', eventData => {
      if(this.clienteSelezionato.id == null) {
        if(!authService.areClientiSalvati()) 
        {
          setTimeout(() => {
            this.loadClienti()
           }, 3000)
        }
        else this.loadClienti();
      }
    });
    this.events.subscribe('functionCall:linguaCambiata', eventData => {
      translate = utilService.translate;
    });
    this.lingue = utilService.getLanguageList();
    if(utilService.getLingua() == "") {
      this.linguaSel = this.lingue[0].key;
      utilService.setLingua(this.linguaSel);
      utilService.translate.setDefaultLang(this.linguaSel);
      utilService.translate.use(this.linguaSel);
    }
    else this.linguaSel = utilService.getLingua();
    translate = utilService.translate;
   }

  clienti: Cliente[];
  clienteSel;
  clienteSelezionato: Cliente;
  linguaSel: string;
  lingue : Array<Pair>;
  
  async loadClienti()
  {
    this.authService.loadClienti().then(state => {
      this.clienti = AuthService.clienti;
      this.clienteSelezionato = AuthService.clienteSelezionato;
      this.events.publish('functionCall:clienteCambiato', null);
    });
    return true;
  }

  cambiaCliente()
  {
    this.authService.setCliente(this.clienteSel);
    this.clienteSelezionato = AuthService.clienteSelezionato;
    this.events.publish('functionCall:clienteCambiato', null);
  }

  cambiaLingua()
  {
    this.utilService.setLingua(this.linguaSel);
    this.utilService.translate.setDefaultLang(this.linguaSel);
    this.utilService.translate.use(this.linguaSel);
    this.events.publish('functionCall:linguaCambiata', null);
  }

  logout(){
    this.authService.logout();
    this.router.navigateByUrl('login');
  }

  ngOnInit() {
  }

  apriPagina(pagina:string)
  {
    this.utilService.apriPagina(pagina);
    this.closeSideMenu();
  }

  

  openSideBar()
  {
    this.menuCtrl.enable(false, 'pareri');
    this.menuCtrl.enable(false, 'topics');
    this.menuCtrl.enable(true, 'mainmenu');
    this.menuCtrl.toggle('mainmenu');
  }

  closeSideMenu() {
    this.menuCtrl.close("mainmenu");
  }
}
