import { Cliente } from './../../auth/interface/cliente';
import { Component } from '@angular/core';
import { Router } from  "@angular/router";
import { MenuController, Platform } from '@ionic/angular';
import { AuthService } from '../../auth/service/auth.service';
import { UtilService } from '../../service/util.service';
import { Pair } from 'src/app/interface/pair';
import { TranslateService } from '@ngx-translate/core';
import { SegreteriaService } from './../../service/segreteria.service';
import { StruttureResponse } from './../../interface/strutture-response';
import { ErrorResponse } from '../../auth/interface/error-response';
import { environment } from '../../../environments/environment';
import { Struttura } from 'src/app/interface/struttura';
import { ParereResponse } from 'src/app/interface/parere-response';
import { EventsService } from 'src/app/service/events.service';

@Component({
  selector: 'app-home',
  templateUrl: 'home.page.html',
  styleUrls: ['home.page.scss']
})
export class HomePage {
  constructor(
    private  authService:  AuthService,
    private segreteriaService: SegreteriaService,
    private  router:  Router, 
    public menuCtrl: MenuController, 
    private utilService: UtilService, 
    public translate: TranslateService,
    public platform: Platform
    ) {
      this.caricaDati(true);
   }

   caricaDati(startUp: boolean)
   {
    this.clienti = [];
    this.titoloPagina = "";
    this.clienteSelezionato = {
      denominazione: null,
      id: null
    };
    this.tipoStruttura = environment.struttura;
    /*this.authService.isLoggedIn().then(state => {
      if (!state) {
        this.router.navigate(['login']);
      }
    });*/
    if(!this.eventIdleInitilized)
    {
      this.eventIdleInitilized = true;
      this.eventsIdle();
    }
    this.lingue = this.utilService.getLanguageList();
    if(this.utilService.getLingua() == "") {
      this.linguaSel = this.lingue[0].key;
      this.utilService.setLingua(this.linguaSel);
      this.utilService.translate.setDefaultLang(this.linguaSel);
      this.utilService.translate.use(this.linguaSel);
    }
    else this.linguaSel = this.utilService.getLingua();
    this.translate = this.utilService.translate;
    this.platform.backButton.subscribeWithPriority(0, () => {
      let defaultUrl: string []=[
        "/home",
        "/login",
        "/reset",
        "/businesscall",
        "/privacy",
        "/home/index",
        "/home/documenti",
        "/home/change-pwd",
        "/home/segreteria",
        "/home/notifiche"
      ];

      if(defaultUrl.indexOf(this.router.url) != -1)
      {
        if(!AuthService.isClienteLoggato)
        {
          switch(this.router.url)
          {
            case "/login":
            {
              navigator['app'].exitApp();
              break;
            }
            case "/home":
            case "/home/index":
            case "/reset":
            case "/businesscall":
            case "/home/preview-home":
            {
              this.router.navigateByUrl('login');
              break;
            }
            case "/privacy":
            {
              this.router.navigateByUrl('businesscall');
              break;
            }
            case "/home/documenti":
            case "/home/change-pwd":
            case "/home/segreteria":
            case "/home/notifiche":
            {
              this.router.navigateByUrl('home/index');
              break;
            }
          }
        }
      }
      else EventsService.setManageBackButton();
    });
   }

  eventsIdle()
  {
    this.translate = this.utilService.translate;
    this.titoloPagina = UtilService.titoloPagina;
    if(EventsService.caricaDati) this.caricaDati(false);
      if(EventsService.startup)
        if(this.clienteSelezionato.id == null) {
          if(!this.authService.areClientiSalvati())
          {
            setTimeout(() => {
              this.loadClienti()
            }, 3000)
          }
          else this.loadClienti();
        }
      if(EventsService.redirect.length > 0) this.redirectTo();
      if(EventsService.strutturaSelected) this.strutturaSelected();
    setTimeout(() => {      
      this.eventsIdle();
    }, environment.eventsTime);
  }

  redirectTo()
  {
    switch(EventsService.redirect)
    {
      case 'pareri':
      {
        this.router.navigateByUrl('home/parere');
        break;
      }
      case 'notifiche':
      {
        this.router.navigateByUrl('home/notifiche');
        break;
      }
      case 'interviste':
      {
        this.router.navigateByUrl('home/interviste');
        break;
      }
    }
  }

   isTitolo()
   {
     return this.titoloPagina != '';
   }

   async loadStrutture()
   {
   var id = await this.authService.getId();
     //this.utilService.showLoading();
    if(AuthService.clienteSelezionato != null) id = AuthService.clienteSelezionato.id.toString();
      this.segreteriaService.getStrutture(id, this.tipoStruttura).subscribe((res: StruttureResponse)=>{
        //this.utilService.closeLoading();
        UtilService.strutture = res.strutture;
        UtilService.strutturaSegreteria = res.strutture[0];
        /*this.events.publish('functionCall:updateStrutture', null);
        this.setStrutture();*/
        if(!AuthService.isClienteLoggato)
          this.segreteriaService.getStruttureByReferente(AuthService.idReferente, this.tipoStruttura).subscribe((res: StruttureResponse)=>{
            //this.utilService.closeLoading();
            UtilService.strutture =  this.concat(UtilService.strutture, res.strutture);
            EventsService.setUpdateStrutture();
            this.setStrutture();
            this.isClienteLoggato = AuthService.isClienteLoggato;
            if(!AuthService.isClienteLoggato && !UtilService.strutture.includes(this.utilService.getStrutturaSel()))
              this.router.navigateByUrl('home/preview-home');
          },
          (error: ErrorResponse) => {
            //this.utilService.closeLoading();
            var text = "Errore durante la richiesta lista strutture";
            this.utilService.stampaErrore(text, error);
          });
        else{
          EventsService.setUpdateStrutture();
          this.isClienteLoggato = AuthService.isClienteLoggato;
          this.utilService.apriPagina('notifiche');
        }

      },
      (error: ErrorResponse) => {
        //this.utilService.closeLoading();
        var text = "Errore durante la richiesta lista strutture";
        this.utilService.stampaErrore(text, error);
      });
   }
  
   concat(str1: Struttura[], str2: Struttura[]): Struttura[] {
    let strFinale: Struttura[] = [];
    for(let struttura of str1)
    {
      let trovato: boolean = false;
      for(let struttura2 of str2)
      {
        if(struttura.id == struttura2.id) trovato = true;
      }
      if(!trovato) strFinale.push(struttura);
    }    
    return strFinale.concat(str2);
  }   

  clienti: Cliente[];
  clienteSel;
  clienteSelezionato: Cliente;
  linguaSel: string;
  lingue : Array<Pair>;
  tipoStruttura: string;
  showMenuButton: boolean = false;
  consultingService: Struttura;
  mediatoreCreditizio: Struttura;
  realEstateBrokerage: Struttura;
  idStrutturaSel: number;
  titoloPagina: string;
  isClienteLoggato: boolean;
  strutturaName: string;
  eventIdleInitilized : boolean = false;

  selectStruttura(struttura:string)
  {
    if(struttura == "notifiche")
    {
      this.utilService.apriPagina(struttura);
      this.closeSideMenu();
      return;
    }
    let ok = false;
    switch(struttura)
    {
      case "servizi":
      {
        this.utilService.setStrutturaSel(this.consultingService);
        this.utilService.setStrutturaName("consulting");
        ok = true;
        
        break;
      }
      case "immobiliare":
      {
        this.utilService.setStrutturaSel(this.realEstateBrokerage);
        ok = true;
        
        this.utilService.setStrutturaName("immobiliare");
        break;
      }
      case "creditizia":
      {        
        this.utilService.setStrutturaSel(this.mediatoreCreditizio);
        ok = true;
        
        this.utilService.setStrutturaName("creditizio");
        break;
      }
    }
    this.strutturaSelected();
    EventsService.setStrutturaSelectedHome();
    EventsService.setClienteCambiato();
  }

  strutturaSelected()
  {
    var struttutaSel = this.utilService.getStrutturaSel();
    if(struttutaSel != null) this.idStrutturaSel = struttutaSel.id;
    else this.idStrutturaSel = 0;
    this.showMenuButton = true;
    if(!this.platform.is("desktop")) this.closeSideMenu();
    UtilService.titoloPagina = '';
    this.strutturaName = this.utilService.getStrutturaName();
    this.router.navigateByUrl('home/index');
  }

  gotoPreview()
  {
    //if(AuthService.isClienteLoggato) return;
    this.utilService.apriPagina("preview-home");
  }

  setStrutture()
  {
    this.utilService.getStruttura(environment.ConsultingServiceId).then(struttura => 
    {
      this.consultingService = struttura;
    });
    this.utilService.getStruttura(environment.MediatoreCreditizioId).then(struttura => 
    {
      this.mediatoreCreditizio = struttura;
    });
    this.utilService.getStruttura(environment.RealEstateBrokerageId).then(struttura => 
    {
      this.realEstateBrokerage = struttura;
    });
  }
  
  async loadClienti()
  {
    this.authService.loadClienti().then(async state =>  {
      this.clienti = AuthService.clienti;
      this.isClienteLoggato = AuthService.isClienteLoggato;
      this.clienteSelezionato = AuthService.clienteSelezionato;
      EventsService.setClienteCambiato();
      this.loadStrutture();
    });
    return true;
  }

  cambiaCliente()
  {
    this.authService.setCliente(this.clienteSel);
    this.clienteSelezionato = AuthService.clienteSelezionato;
    EventsService.setClienteCambiato();
    this.loadStrutture();
  }

  cambiaLingua()
  {
    this.utilService.setLingua(this.linguaSel);
    this.utilService.translate.setDefaultLang(this.linguaSel);
    this.utilService.translate.use(this.linguaSel);
  }

  logout(){
    //this.authService.logout();
    //this.router.navigateByUrl('login');
    this.utilService.logout();
  }

  async getBC ()
  {
    (await this.utilService.chiediBCall()).subscribe((ok: ParereResponse) => {
      if(ok.autorizzato) this.utilService.presentAlert("Info", "", "Business Call richiesta", ["OK"]);
      else this.utilService.presentAlert("Errore", "", "C'è stato un problema con il server, riprovare tra qualche minuto!", ["OK"]);
    });
  }

  ngOnInit() {
  }

  apriPagina(pagina:string)
  {
    this.utilService.apriPagina(pagina);
    this.closeSideMenu();
  }

  

  openSideBar()
  {
    this.menuCtrl.enable(false, 'pareri');
    this.menuCtrl.enable(false, 'topics');
    this.menuCtrl.enable(true, 'mainmenu');
    this.menuCtrl.toggle('mainmenu');
  }

  closeSideMenu() {
    this.menuCtrl.close("mainmenu");
  }
}
