import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  { path: '', loadChildren: './pages/home/home.module#HomePageModule' },
  { path: 'login', loadChildren: './auth/pages/login/login.module#LoginPageModule' },
  { path: 'reset', loadChildren: './auth/pages/reset/reset.module#ResetPageModule' },
  { path: 'documenti', loadChildren: './pages/documenti/documenti.module#DocumentiPageModule'},   
  { path: 'businesscall', loadChildren: './pages/businesscall/businesscall.module#BusinesscallPageModule' },
  { path: 'privacy', loadChildren: './pages/privacy/privacy.module#PrivacyPageModule' }

];
@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule {}
