import { Component } from '@angular/core';

import { MenuController } from '@ionic/angular';
import { AuthService } from './auth/service/auth.service';
import { Router } from '@angular/router';
import { UtilService } from './service/util.service';
import { Storage } from '@ionic/storage-angular';

@Component({
  selector: 'app-root',
  templateUrl: 'app.component.html'
})
export class AppComponent {
  constructor(
    private router: Router,
    private authService: AuthService,
    private utilService:  UtilService,
    public menuCtrl: MenuController,
    private  storage:  Storage,

  ) {
    this.initializeApp();
  }

  created : boolean = false;

  async initializeApp() {
    if(!this.created)
    {
      await this.storage.create();
      this.created = true;
    }
    this.utilService.loadLingua();
    if(UtilService.isNotificaResume == null) UtilService.isNotificaResume = false;
    this.utilService.initConfig(false, 'notifiche');
  }

  async logout(){
    await this.authService.logout();
    this.router.navigateByUrl('login');
  }

  apriPagina(pagina:string)
  {
    switch(pagina)
    {
      case "home":
      {
        this.router.navigateByUrl('index');
        break;
      }
      case "documenti":
      {
        this.router.navigateByUrl('documenti');
        break;
      }
      case "interviste":
      {
        this.router.navigateByUrl('interviste');
        break;
      }
      case "pareri":
      {
        this.router.navigateByUrl('pareri');
        break;
      }
      case "segreteria":
      {
        this.router.navigateByUrl('segreteria');
        break;
      }
      case "change-password":
      {
        this.router.navigateByUrl('change-pwd');
        break;
      }
    }
  }

  openSideBar()
  {
    this.menuCtrl.open('mainmenu');
  }

  closeSideMenu() {
    this.menuCtrl.close();
  }
}
