import { Injectable } from '@angular/core';
import { Observable, of} from  'rxjs';
import { Pair } from './../interface/pair';
import { NotificheRequest } from '../interface/notifiche-request';
import { tap, catchError } from  'rxjs/operators';
import { ErrorResponse } from '../auth/interface/error-response';
import { HttpClient, HttpErrorResponse } from '@angular/common/http';
import { HttpClientDataService } from '../service/http-client-data.service';
import { NotificheResponse } from '../interface/notifiche-response';
import { ArchiviaNotificaResponse } from '../interface/archivia-notifica-response';
import { ArchiviaNotificaRequest } from '../interface/archivia-notifica-request';

@Injectable({
  providedIn: 'root'
})
export class NotificheService {
  
  constructor(
    private  httpClient: HttpClient,
    private  httpClientDataService: HttpClientDataService
  ) {
    this.initService();
  }

  archiviaNotifiche(id: any, archiviare: boolean, notificheSelezionate: number[]) {
    var notifica = this.creaNotificaArchiviazione(id, archiviare, notificheSelezionate);
    var param = this.encodeArchiviaNotifica(notifica);
    return this.httpClient.post<ArchiviaNotificaResponse>(this.httpClientDataService.BASE_ADDRESS+'/intranet/setnotifichedaarchiviare.do', param, this.httpClientDataService.httpOptionsJson)
      .pipe(
      catchError(this.handleError),
      tap( (res: ArchiviaNotificaResponse ) => {

        if (!res.error) {
          this.errorRespose.error = false;
          return res;
        }
        else{
          this.errorRespose.error = true;
          this.errorRespose.errorMsg = res.error;          
        }
      })
    );
  }

  creaNotificaArchiviazione(id, archiviare, notificheSelezionate): ArchiviaNotificaRequest
  {
    var notifiche: ArchiviaNotificaRequest;
    notifiche = {
      cliente: id,
      daArchiviare: archiviare,
      listaNotifiche: notificheSelezionate
    };

    return notifiche;
  }

  encodeArchiviaNotifica(params: ArchiviaNotificaRequest)
  {
    var request ="{\"cliente\" : " + params.cliente + ", \"daArchiviare\" : " + params.daArchiviare + ", \"listaNotifiche\" : [";
    var first = true;
    for(let notifica of params.listaNotifiche)
    {
      if(first) 
      {
        first = false;
        request += "\""+notifica+"\"";
      }
      else request += ", \""+notifica+"\"";
    }
    request += "]}";
    return request;
  }

  initService()
  {
    this.errorRespose = { 
      error: true,
      errorMsg: ""
    };
  }

  errorRespose: ErrorResponse; 

  handleError(error: HttpErrorResponse) {
    this.errorRespose = { 
      error: true,
      errorMsg: ""
    };
    if (error.error instanceof ErrorEvent) {
      this.errorRespose.errorMsg = error.error.message;
    } else {
      this.errorRespose.errorMsg = error.error;
    }
    return of(this.errorRespose);
  };

  getListaNotifiche(idCliente: string, idReferente: string, archiviati: boolean, titolo: string): Observable<NotificheResponse>
  {
    var richiesta = this.creaRichiesta(idCliente, idReferente, 10, null, null, archiviati, titolo);
    var param = this.encodeBody(richiesta);
    return this.httpClient.post<NotificheResponse>(this.httpClientDataService.BASE_ADDRESS+'/intranet/notifiche.do', param, this.httpClientDataService.httpOptionsJson)
      .pipe(
      catchError(this.handleError),
      tap( (res:  NotificheResponse ) => {

        if (!res.error) {
          this.errorRespose.error = false;
          return res;
        }
        else{
          this.errorRespose.error = true;
          this.errorRespose.errorMsg = res.error;          
        }
      })
    );
  }

  creaRichiesta(id, referente, limite, dataDa, dataA, archiviati, titolo): NotificheRequest
  {
    var request:NotificheRequest;
    var pair:Pair;
    var pairs: Pair[] = new Array();

    if(archiviati != null)
    {
      pair = {
        key: "archiviato",
        value: archiviati,
        type: "boolean"
      }
      pairs.push(pair);
    }

    if(titolo != null)
    {
      pair = {
        key: "titolo",
        value: titolo,
        type: "string"
      }
      pairs.push(pair);
    }
    pairs.push(pair);

    request = {
      cliente: id,
      referente: referente,
      limite: limite,
      filtri: pairs
    };

    return request;
  }

  encodeBody(params: NotificheRequest) {
    var request = "{\"cliente\" : "+params.cliente+",\"referente\" : "+params.referente+",\"limite\" : "+params.limite+",\"filtri\" : {";
    var filtro;
    var first = true;
    var i;
    for (i = 0; i < params.filtri.length; i++) {
      filtro = params.filtri[i];
      if(first) first = false;
      else request += ", ";
      if(filtro.type == "int" || filtro.type == "boolean")
        request += "\""+filtro.key + "\":"+filtro.value;
      else
        request += "\""+filtro.key + "\":\""+filtro.value+"\"";
    }
    request += "}}";
    return request;
  }
}
