import { Component, OnInit } from '@angular/core';
import { HttpClientDataService } from './../../service/http-client-data.service';
import { UtilService } from '../../service/util.service';
import { AuthService } from 'src/app/auth/service/auth.service';
import { ErrorResponse } from '../../auth/interface/error-response';
import { Platform, Events, MenuController } from '@ionic/angular';
import { TranslateService } from '@ngx-translate/core';
import { Router } from  "@angular/router";
import { Notifica } from 'src/app/interface/notifica';
import { NotificheService } from 'src/app/service/notifiche.service';
import { NotificheResponse } from 'src/app/interface/notifiche-response';
import { ArchiviaNotificaResponse } from 'src/app/interface/archivia-notifica-response';

@Component({
  selector: 'app-notifiche',
  templateUrl: './notifiche.page.html',
  styleUrls: ['./notifiche.page.scss'],
})
export class NotifichePage implements OnInit {

  constructor(
    public menuCtrl: MenuController,
    private utilService:  UtilService,
    public platform: Platform,
    public events: Events,
    private notificheService: NotificheService,
    public httpClientDataService: HttpClientDataService,
    public translate: TranslateService,
    public router: Router
  ) {
    this.events.publish('functionCall:startup', null);
    this.initPage();
    if(AuthService.clienteSelezionato.id != null) this.loadNotifiche();
    this.events.subscribe('functionCall:clienteCambiato', eventData => { 
      this.loadNotifiche();
    });
    this.events.subscribe('functionCall:linguaCambiata', eventData => {
      translate = utilService.translate;
    });
    this.events.subscribe('functionCall:manageBackButton', eventData => {
      if(this.router.url == "/home/parere")
      {
        if(this.notifica == "lista") 
        {
          
          UtilService.titoloPagina = '';
          this.events.publish('functionCall:cambiaTitolo', null);
          this.router.navigateByUrl('home/index');
        }
        else 
        {
          this.apriLista();
          this.router.navigateByUrl('home/index');
          setTimeout(() => {
            this.events.publish('functionCall:notifica', null);
            }, 500);
        }
      }
    });
    translate = utilService.translate;
    setTimeout(() => {
      this.refreshNotifiche();
    }, 60000);
   }

   refreshNotifiche()
  {
    this.loadNotifiche();
    setTimeout(() => {
      this.refreshNotifiche();
    }, 60000);
  }

  ngOnInit() {
  }

  initPage()
  {
    var allegati = new Array();
    this.notificaAttiva = {
      id: null, 
      allegati:allegati,
      titolo: null,
	    contenuto: null,
      checked: false,
      errorText: "",
      archiviato: false,
      haAllegati: false,
      visualizzata: false,
      data: ""
    };
    this.notifica = "lista";
    this.bottoneVisibile = true;
    this.archiviati = false;
    this.notificheSelezionate = new Array();
    this.error = "";
    this.titolo = "";
  }

  notifiche: Notifica[];
  notificaAttiva: Notifica;
  idCliente;
  idSelezionato;
  notifica: string;
  bottoneVisibile: boolean;
  archiviati: boolean;
  titolo: string;

  idSelected: number;
  selection: boolean = false;
  clickCheckbox: boolean = false;

  filename: string = "";
  notificaId;
  notificheSelezionate: Array<number>;
  error: string;

  toggleGroup(id : number)
  {
    if(this.clickCheckbox)
    {
      this.clickCheckbox = false;
      return;
    }
    this.selection = true;
    this.idSelected = id;
    this.hideButtons()
    this.notifiche.forEach(this.toggle, this);
  }

  toggle(notifica: Notifica, index)
  {
    if(notifica.id == this.idSelected)
    {
      if(notifica.checked)  notifica.checked = false;
      else{
        notifica.checked = true;
        this.showButtons();
      }
    }
    else if(notifica.checked) this.showButtons();
  }

  selectItem(id: number) {
    if(this.clickCheckbox)
    {
      this.clickCheckbox = false;
      return;
    }
    this.selection = true;
    this.idSelected = id;
    this.hideButtons()
    this.notifiche.forEach(this.select, this);
  }

  select(notifica: Notifica, index)
  {
    if(notifica.id == this.idSelected)
    {
      notifica.checked = true;
      this.showButtons();
    }
  }

  showButtons()
  {
    var buttons = document.getElementById('buttonsNotifiche');
    buttons.setAttribute("style", "display:block");
  }

  hideButtons()
  {
    var buttons = document.getElementById('buttonsNotifiche');
    if(buttons != null) buttons.setAttribute("style", "display:none");
  }

  cercaNotifiche()
  {
    this.loadNotifiche();
  }

  getFile(url, nomeFile)
  {
    var fileUrl = this.httpClientDataService.BASE_ADDRESS+url;
    this.utilService.shareDocumento(fileUrl, nomeFile);
  }

  async loadNotifiche()
  {
    this.hideButtons();
    var titolo = null;
    this.utilService.showLoading();
    this.idCliente = AuthService.clienteSelezionato.id;
    let referente = AuthService.idReferente;
    if(this.titolo != null && this.titolo != "") titolo = this.titolo;
    this.notificheService.getListaNotifiche(this.idCliente, referente, this.archiviati, titolo).subscribe((res: NotificheResponse)=>{ 
        this.utilService.closeLoading();
        if(res.error){
          this.utilService.presentAlert("Errore", "", res.error, ["OK"]);
        }
        else 
        {
          this.notifiche = res.notifiche;
          if(this.notifiche != null && this.notifiche.length > 0) this.notificaAttiva = this.notifiche[0];
        }
      },
      (error: ErrorResponse) => {
        this.utilService.closeLoading();
        var text = "Errore durante la procedura di richiesta Topic";
        this.utilService.stampaErrore(text, error);
      }
    );
  }

  apriLista()
  {
    this.notifica = "lista";
  }

  apriNotifica(id)
  {
    this.idSelezionato = id;
    this.notifiche.forEach(this.setNotifica, this);
  }

  setNotifica(notifica, index)
  {
    if(notifica.id == this.idSelezionato)
    { 
      this.notificaAttiva = notifica;
      this.notifica = "dettaglio";
    }
  }

  trackByDoc(index: number, notifica: Notifica): number { return notifica.id; }
  
  checkSelected(id)
  {
    this.clickCheckbox = true;
    this.notificaId = id;
    this.hideButtons()
    this.notifiche.forEach(this.check, this);
  }

  check(richiesta: Notifica, index)
  {
    if(richiesta.checked && richiesta.id != this.notificaId) this.showButtons();
    if(!richiesta.checked && richiesta.id == this.notificaId) this.showButtons();
  }

  archiviaNotifiche(archiviare: boolean)
  {
    this.utilService.showLoading();
    this.notificheSelezionate = new Array();
    this.notifiche.forEach(this.raccogliNotifiche, this);
    this.notificheService.archiviaNotifiche(this.idCliente, archiviare, this.notificheSelezionate).subscribe((res: ArchiviaNotificaResponse)=>{
      this.utilService.closeLoading();
      if(res.error){
        this.utilService.presentAlert("Errore", "", res.error, ["OK"]);
      }
      else 
      {
        if(res.notificheNonArchiviate.length > 0)
        {
          this.error = "Questa è la lista degli errori:\r\n"
          res.notificheNonArchiviate.forEach(this.getErrori, this);
          this.utilService.presentAlert("Errore", "", this.error, ["OK"]);
        }
        else{
          this.hideButtons();
          this.loadNotifiche();
          this.apriLista();
        }
      }
    },
    (error: ErrorResponse) => {
      this.utilService.closeLoading();
      var text = "Errore durante l'archiviazione del parere";
      this.utilService.stampaErrore(text, error);
    });
  }

  getErrori(errore: Notifica, index)
  {
    this.error = "Notifica n° " + errore.id + ":" + errore.errorText;
  }

  raccogliNotifiche(notifica: Notifica, index)
  {
    if(notifica.checked) this.notificheSelezionate.push(notifica.id);
  }

  back()
  {
    
    UtilService.titoloPagina = '';
    this.events.publish('functionCall:cambiaTitolo', null);
    this.router.navigateByUrl('home/index');
  }

}
