import { Pair } from './../../interface/pair';
import { HttpClientDataService } from './../../service/http-client-data.service';
import { StruttureResponse } from './../../interface/strutture-response';
import { Struttura } from './../../interface/struttura';
import { FattureResponse } from './../../interface/fatture-response';
import { FattureRequest } from './../../interface/fatture-request';
import { Fattura } from './../../interface/fattura';
import { Component, OnInit } from '@angular/core';
import { UtilService } from './../../service/util.service';
import { AuthService } from 'src/app/auth/service/auth.service';
import { SegreteriaService } from './../../service/segreteria.service';
import { ErrorResponse } from '../../auth/interface/error-response';
import { Platform } from '@ionic/angular';
import { DatePicker } from '@ionic-native/date-picker/ngx';
import { TranslateService } from '@ngx-translate/core';
import { environment } from '../../../environments/environment';
import { InAppBrowser, InAppBrowserOptions } from '@ionic-native/in-app-browser/ngx';
import { Router } from  "@angular/router";
import { EventsService } from 'src/app/service/events.service';

@Component({
  selector: 'app-segreteria',
  templateUrl: './segreteria.page.html',
  styleUrls: ['./segreteria.page.scss'],
})
export class SegreteriaPage implements OnInit {

  constructor(
    private authService: AuthService, 
    private  utilService: UtilService, 
    private segreteriaService: SegreteriaService,
    public platform: Platform,
    private datePicker: DatePicker,
    public httpClientDataService: HttpClientDataService,
    private  router:  Router,
    public translate: TranslateService,
    private iab: InAppBrowser
  ) 
  { 
    EventsService.setStartUp();
    this.initPage();
    if(AuthService.clienteSelezionato.id != null)
    { 
      this.loadData();
    }
    this.eventsIdle();
  }

  eventsIdle()
  {
    this.translate = this.utilService.translate;
    setTimeout(() => {
      if(EventsService.clienteCambiato) this.loadData();
      if(EventsService.strutturaSelected) this.loadStrutture();
      this.eventsIdle();
    }, environment.eventsTime);
  }

  loadData()
  {
    this.loadStrutture();
  }

  segreteria: string;
  fatture: Fattura[];
  idCliente;
  strutturaSel: Struttura;
  idStrutturaSel;
  strutture: Struttura[];
  date1;
  date2;
  nProgNotula: string;
  nNotula: string;
  fattureSel: Array<Pair>;
  tipoStruttura: string;
  visualizzaProgetti: boolean;

  options : InAppBrowserOptions = {
    location : 'yes',//Or 'no' 
    hidden : 'no', //Or  'yes'
    clearcache : 'yes',
    clearsessioncache : 'yes',
    zoom : 'yes',//Android only ,shows browser zoom controls 
    hardwareback : 'yes',
    mediaPlaybackRequiresUserAction : 'no',
    shouldPauseOnSuspend : 'no', //Android only 
    closebuttoncaption : 'Close', //iOS only
    disallowoverscroll : 'no', //iOS only 
    toolbar : 'yes', //iOS only 
    enableViewportScale : 'no', //iOS only 
    allowInlineMediaPlayback : 'no',//iOS only 
    presentationstyle : 'pagesheet',//iOS only 
    //fullscreen : 'yes',//Windows only    
  };

  initPage()
  {
    this.fatture = [];
    var date : Date;
    date = new Date();
    this.date1 = "";
    this.date2 = "";
    this.segreteria = "fatture";
    this.strutturaSel = null;
    this.idStrutturaSel = null;
    this.strutture = [];
    this.nProgNotula = "";
    this.nNotula = "";
    this.fattureSel = new Array();
    this.tipoStruttura = environment.struttura;
    this.visualizzaProgetti = false;
  }

  idSelected: number;
  selection: boolean = false;
  clickCheckbox: boolean = false;

  toggleGroup(id : number)
  {
    if(this.clickCheckbox)
    {
      this.clickCheckbox = false;
      return;
    }
    this.selection = true;
    this.idSelected = id;
    this.hideButtons()
    this.fatture.forEach(this.toggle, this);
  }

  toggle(fattura: Fattura, index)
  {
    if(fattura.id == this.idSelected)
    {
      if(fattura.checked)  fattura.checked = false;
      else{
        fattura.checked = true;
        this.showButtons();
      }
    }
    else if(fattura.checked) this.showButtons();
  }

  selectItem(id: number) {
    // alert ("INsiede item selection");
    if(this.clickCheckbox)
    {
      this.clickCheckbox = false;
      return;
    }
    this.selection = true;
    this.idSelected = id;
    this.hideButtons()
    this.fatture.forEach(this.select, this);
  }

  select(fattura: Fattura, index)
  {
    if(fattura.id == this.idSelected)
    {
      fattura.checked = true;
      this.showButtons();
    }
  }

  condividiFatture()
  {
    this.fattureSel = new Array();
    this.fatture.forEach(this.recuperaFattura, this);
    this.utilService.shareDocumenti(this.fattureSel);
  }

  async recuperaFattura(fattura: Fattura, index)
  {
    if(fattura.checked != null && fattura.checked) {
      var tipo = "";
      var nomeFile = "";
      if(fattura.nrNotula == null)
      {
        tipo = "P";
        nomeFile = fattura.nrProgNotula;
      }
      else {
        tipo = "N";
        nomeFile = fattura.nrNotula;
      }
      nomeFile += ".pdf";
      var fileUrl = this.httpClientDataService.BASE_ADDRESS+"/intranet/notula.do?idcliente="+AuthService.clienteSelezionato.id+"&idnotula="+fattura.id+"&tipo="+tipo;
      var coppia: Pair;
      coppia = {
        key: nomeFile,
        value: fileUrl,
        type: "string"
      }
      this.fattureSel.push(coppia);
    }
  }

  fatturaId;

  checkSelected(id)
  {
    this.clickCheckbox = true;
    this.fatturaId = id;
    this.hideButtons()
    this.fatture.forEach(this.check, this);
  }

  check(fattura: Fattura, index)
  {
    if(fattura.checked && fattura.id != this.fatturaId) this.showButtons();
    if(!fattura.checked && fattura.id == this.fatturaId) this.showButtons();
  }

  showButtons()
  {
    var buttons = document.getElementById('buttons');
    buttons.setAttribute("style", "display: block");
  }

  hideButtons()
  {
    var buttons = document.getElementById('buttons');
    buttons.setAttribute("style", "display: none");
  }

  changeSel(sel)
  {
    this.segreteria = sel;
    var fatture = document.getElementById('icon-fatture');
    var estratto = document.getElementById('icon-estratto');
    var solleciti = document.getElementById('icon-solleciti');
    var fatturelabel = document.getElementById('label-fatture');
    var estrattolabel = document.getElementById('label-estratto');
    var sollecitilabel = document.getElementById('label-solleciti');


    switch(sel)
    {
      case "fatture":
      {
        fatture.setAttribute("src", "assets/icon/fatture-progetti-bianco.svg");
        fatturelabel.setAttribute("style", "color: white;");
        estratto.setAttribute("src", "assets/icon/estratto-conto-grigio.svg");
        estrattolabel.setAttribute("style", "color:#515151;");
        solleciti.setAttribute("src", "assets/icon/solleciti-grigio.svg");
        sollecitilabel.setAttribute("style", "color:#515151;");
        break;
      }
      case "estratto":
      {
        fatture.setAttribute("src", "assets/icon/fatture-progetti-grigio.svg");
        fatturelabel.setAttribute("style", "color:#515151;");
        estratto.setAttribute("src", "assets/icon/estratto-conto-bianco.svg");
        estrattolabel.setAttribute("style", "color: white;");
        solleciti.setAttribute("src", "assets/icon/solleciti-grigio.svg");
        sollecitilabel.setAttribute("style", "color:#515151;");
        break;
      }
      case "solleciti":
      {
        fatture.setAttribute("src", "assets/icon/fatture-progetti-grigio.svg");
        fatturelabel.setAttribute("style", "color:#515151;");
        estratto.setAttribute("src", "assets/icon/estratto-conto-grigio.svg");
        estrattolabel.setAttribute("style", "color:#515151;");
        solleciti.setAttribute("src", "assets/icon/solleciti-bianco.svg");
        sollecitilabel.setAttribute("style", "color: white;");
        break;
      }
    }
  }

  setDateDa()
  {
    this.datePicker.show({
      date: new Date(),
      mode: 'date',
      androidTheme: this.datePicker.ANDROID_THEMES.THEME_HOLO_DARK
    }).then(
      date => this.date1 = this.utilService.getAndroidDateString(date),
      err => console.log('Error occurred while getting date: ', err)
    );
  }

  setDateA()
  {
    this.datePicker.show({
      date: new Date(),
      mode: 'date',
      androidTheme: this.datePicker.ANDROID_THEMES.THEME_HOLO_DARK
    }).then(
      date => this.date2 = this.utilService.getAndroidDateString(date),
      err => console.log('Error occurred while getting date: ', err)
    );
  }

  resetDate()
  {
    this.date1 = "";
    this.date2 = "";
  }

  getNotula(idNotula, nomeFile, isProgNotula)
  {
    var tipo = "";
    if(isProgNotula) tipo = "P";
    else tipo = "N";
    var fileUrl = this.httpClientDataService.BASE_ADDRESS+"/intranet/notula.do?idcliente="+AuthService.clienteSelezionato.id+"&idnotula="+idNotula+"&tipo="+tipo;
    nomeFile += ".pdf";
    this.utilService.downloadDocumento(fileUrl, nomeFile);
    /*nomeFile += ".pdf";
    this.utilService.shareDocumento(fileUrl, nomeFile);*/
  }

  getEstrattoConto(idCliente, nomeFile, idStruttura)
  {
    var fileUrl = this.httpClientDataService.BASE_ADDRESS+"/intranet/estrattoconto.do?idcliente="+idCliente+"&idstruttura="+idStruttura;
    //this.utilService.downloadDocumento(fileUrl, nomeFile);
    this.utilService.shareDocumento(fileUrl, nomeFile);
  }

  downloadEstrattoConto()
  {
    var strutturaSel = this.utilService.getStrutturaSel();
    if(this.platform.is("desktop"))
    {
      var url = this.httpClientDataService.BASE_ADDRESS+"/intranet/estrattoconto.do?idcliente="+this.idCliente+"&idstruttura="+strutturaSel.id;
      window.open(url, "_system");
    }
    else this.getEstrattoConto(this.idCliente, 'EstrattoConto.pdf', strutturaSel.id);
  }

  async redirectTo2p2()
  {
    var id = await this.authService.getId();
    id = 1100;
    this.segreteriaService.getP2pToken(id).subscribe((res)=>{
      var token = res.token;
      if(this.platform.is("desktop")) window.open(this.httpClientDataService.P2PSingleSignOnUrl+token, "_system");
      else this.iab.create(this.httpClientDataService.P2PSingleSignOnUrl+token, "_blank", this.options);
      //else this.iab.create("http://www.google.it", "_blank", this.options);
    },
    (error: ErrorResponse) => {
      var text = "Errore durante l'sso verso 2P2";
      this.utilService.stampaErrore(text, error);
    });
  }

  cambiaStruttura()
  {
    var i;
    for(i = 0;i < this.strutture.length;i++)
    {
      if(this.idStrutturaSel == this.strutture[i].id) 
        this.strutturaSel = this.strutture[i];
    }
    this.loadFatture('initial');
  }

  loadStrutture()
  {
    //this.utilService.showLoading();
    /*this.segreteriaService.getStrutture(AuthService.clienteSelezionato.id, this.tipoStruttura).subscribe((res: StruttureResponse)=>{
      //this.utilService.closeLoading();
      this.strutture = res.strutture;
      if(this.strutture.length > 0)
      { 
        this.strutturaSel = this.strutture[0];
        this.loadFatture('initial');
      }

    },
    (error: ErrorResponse) => {
      //this.utilService.closeLoading();
      var text = "Errore durante la richiesta lista strutture";
      this.utilService.stampaErrore(text, error);
    });*/
    this.strutturaSel = this.utilService.getStrutturaSel();
    this.loadFatture('initial');
  }

  cercaFatture()
  {
    this.loadFatture("ricerca");
  }

  loadFatture(fase)
  {
    var dataA = null;
    var dataDa = null;
    var numeroN = null;
    var numeroP = null;
    if(this.nNotula!= null  && this.nNotula != "") numeroN = this.nNotula;
    if(this.nProgNotula != null  && this.nProgNotula != "") numeroP = this.nProgNotula;
    if(this.date1 != null  && this.date1 != "") dataDa = this.utilService.dateFormatConvert(this.date1);
    if(this.date2 != null  && this.date2 != "") dataA = this.utilService.dateFormatConvert(this.date2);
    var request: FattureRequest;
    this.idCliente = AuthService.clienteSelezionato.id;
    var strutturaSel = null;
    if(this.platform.is("desktop")) strutturaSel = this.utilService.getStrutturaSel();
    else strutturaSel = this.strutturaSel;
    if(strutturaSel == null) return;
    this.utilService.showLoading();
    if(fase == "initial") request = this.segreteriaService.createFatturaRequest(this.idCliente, 10, null, null, numeroP, numeroN, strutturaSel.id); 
    else request = this.segreteriaService.createFatturaRequest(this.idCliente,null, dataDa, dataA, numeroP, numeroN, strutturaSel.id);
    this.segreteriaService.getFatture(request).subscribe((res: FattureResponse)=>{
      this.utilService.closeLoading();
      if(res.error){
        this.utilService.presentAlert("Errore", "", res.error, ["OK"]);
      }
      else 
      {
        this.fatture = res.notule;
      }
    },
    (error: ErrorResponse) => {
      this.utilService.closeLoading();
      var text = "Errore durante richiesta delle fatture";
      this.utilService.stampaErrore(text, error);
    });
  }

  back()
  {
    
    UtilService.titoloPagina = '';
    this.router.navigateByUrl('home/index');
  }

  ngOnInit() {
  }

  trackByDoc(index: number, seg: Fattura): number { return seg.id; }

}
