import { Component, OnInit } from '@angular/core';
import { InAppBrowser, InAppBrowserOptions } from '@ionic-native/in-app-browser/ngx';
import { EventsService } from 'src/app/service/events.service';

@Component({
  selector: 'app-bi',
  templateUrl: './bi.page.html',
  styleUrls: ['./bi.page.scss'],
})
export class BiPage implements OnInit {

  options : InAppBrowserOptions = {
    location : 'yes',//Or 'no' 
    hidden : 'no', //Or  'yes'
    clearcache : 'yes',
    clearsessioncache : 'yes',
    zoom : 'yes',//Android only ,shows browser zoom controls 
    hardwareback : 'yes',
    mediaPlaybackRequiresUserAction : 'no',
    shouldPauseOnSuspend : 'no', //Android only 
    closebuttoncaption : 'Close', //iOS only
    disallowoverscroll : 'no', //iOS only 
    toolbar : 'yes', //iOS only 
    enableViewportScale : 'no', //iOS only 
    allowInlineMediaPlayback : 'no',//iOS only 
    presentationstyle : 'pagesheet',//iOS only 
    //fullscreen : 'yes',//Windows only    
  };

  constructor(private iab: InAppBrowser) { 
    EventsService.setStartUp();
    const browser = this.iab.create('https://ionicframework.com/', "_blank", this.options);
  }

  ngOnInit() {
  }

}
