import { ErrorResponse } from './../../interface/error-response';
import { Component, OnInit, ViewEncapsulation } from '@angular/core';
import { Router } from  "@angular/router";
import { AuthService } from '../../service/auth.service';
import { UtilService } from '../../../service/util.service';
import { Events } from '@ionic/angular';

@Component({
  selector: 'app-login',
  templateUrl: './login.page.html',
  styleUrls: ['./login.page.scss'],
  encapsulation: ViewEncapsulation.None
})
export class LoginPage implements OnInit {

  constructor(private  authService:  AuthService, private  router:  Router, private  utilService:  UtilService, public events: Events,) { }

  async login(form){
    await this.utilService.showLoading();
      this.authService.login(form.value).subscribe((res: ErrorResponse)=>{
        res = this.authService.errorRespose;
        this.utilService.closeLoading();
        if(res.error){
          this.utilService.presentAlert("Errore", "", res.errorMsg, ["OK"]);
        }
        else
        {
          this.events.publish('functionCall:startup', null);
          this.router.navigateByUrl('');
        }
      },
        (error: ErrorResponse) => {
          this.utilService.closeLoading();
          this.utilService.presentAlert("Errore", "", error.errorMsg, ["OK"]);
        }
    );
  }

  redirectBusiness()
  {
    this.router.navigateByUrl('businesscall');
  }

  reset(){
    this.router.navigateByUrl('reset');
  }

  ngOnInit() {
  }

}
