import { ErrorResponse } from './../../interface/error-response';
import { Component, OnInit, ViewEncapsulation } from '@angular/core';
import { Router } from  "@angular/router";
import { AuthService } from '../../service/auth.service';
import { UtilService } from '../../../service/util.service';
import { Platform, Events } from '@ionic/angular';

@Component({
  selector: 'app-login',
  templateUrl: './login.page.html',
  styleUrls: ['./login.page.scss'],
  encapsulation: ViewEncapsulation.None
})
export class LoginPage implements OnInit {

  constructor(private  authService:  AuthService, private  router:  Router, private  utilService:  UtilService, public events: Events,public platform: Platform) { }

  async login(form){
    await this.utilService.showLoading();
      this.authService.login(form.value).subscribe((res: ErrorResponse)=>{
        res = this.authService.errorRespose;
        this.utilService.closeLoading();
        if(res.error){
          this.utilService.presentAlert("Errore", "", res.errorMsg, ["OK"]);
        }
        else
        {
          this.router.navigateByUrl('');
        }
      },
        (error: ErrorResponse) => {
          this.utilService.closeLoading();
          if(error != null && error.errorMsg != null) this.utilService.presentAlert("Errore", "", error.errorMsg, ["OK"]);
          else if(error!=null) this.utilService.presentAlert("Errore", "", error, ["OK"]);
          else this.utilService.presentAlert("Errore", "", "Errore durante la procedura di login", ["OK"]);
        }
    );
  }

  redirectBusiness()
  {
    this.router.navigateByUrl('businesscall');
  }

  reset(){
    this.router.navigateByUrl('reset');
  }

  ngOnInit() {
  }

}
