import { Pair } from './../../interface/pair';
import { HttpClientDataService } from './../../service/http-client-data.service';
import { StruttureResponse } from './../../interface/strutture-response';
import { Struttura } from './../../interface/struttura';
import { FattureResponse } from './../../interface/fatture-response';
import { FattureRequest } from './../../interface/fatture-request';
import { Fattura } from './../../interface/fattura';
import { Component, OnInit } from '@angular/core';
import { UtilService } from './../../service/util.service';
import { AuthService } from 'src/app/auth/service/auth.service';
import { SegreteriaService } from './../../service/segreteria.service';
import { ErrorResponse } from '../../auth/interface/error-response';
import { Platform, Events } from '@ionic/angular';
import { DatePicker } from '@ionic-native/date-picker/ngx';
import { BrowserStack } from 'protractor/built/driverProviders';

@Component({
  selector: 'app-segreteria',
  templateUrl: './segreteria.page.html',
  styleUrls: ['./segreteria.page.scss'],
})
export class SegreteriaPage implements OnInit {

  constructor(
    private authService: AuthService, 
    private  utilService: UtilService, 
    private segreteriaService: SegreteriaService,
    public platform: Platform,
    private datePicker: DatePicker,
    public httpClientDataService: HttpClientDataService,
    public events: Events
  ) 
  { 
    this.events.publish('functionCall:startup', null);
    this.initPage();
    if(AuthService.clienteSelezionato.id != null)
    { 
      this.loadStrutture();
      this.loadFatture('initial');
    }
    this.events.subscribe('functionCall:clienteCambiato', eventData => {
      this.loadStrutture();
      this.loadFatture('initial');
    });
  }

  segreteria: string;
  fatture: Fattura[];
  idCliente;
  strutturaSel: Struttura;
  idStrutturaSel;
  strutture: Struttura[];
  date1;
  date2;
  nProgNotula: string;
  nNotula: string;
  fattureSel: Array<Pair>;

  initPage()
  {
    this.fatture = [];
    var date : Date;
    date = new Date();
    this.date1 = "";
    this.date2 = "";
    this.segreteria = "fatture";
    this.strutturaSel = null;
    this.idStrutturaSel = null;
    this.strutture = [];
    this.nProgNotula = "";
    this.nNotula = "";
    this.fattureSel = new Array();
  }



  condividiFatture()
  {
    this.fattureSel = new Array();
    this.fatture.forEach(this.recuperaFattura, this);
    this.utilService.shareDocumenti(this.fattureSel);
  }

  async recuperaFattura(fattura: Fattura, index)
  {
    if(fattura.checked != null && fattura.checked) {
      var tipo = "";
      var nomeFile = "";
      if(fattura.nrNotula == null)
      {
        tipo = "P";
        nomeFile = fattura.nrProgNotula;
      }
      else {
        tipo = "N";
        nomeFile = fattura.nrNotula;
      }
      nomeFile += ".pdf";
      var fileUrl = this.httpClientDataService.BASE_ADDRESS+"/intranet/notula.do?idcliente="+AuthService.clienteSelezionato.id+"&idnotula="+fattura.id+"&tipo="+tipo;
      var coppia: Pair;
      coppia = {
        key: nomeFile,
        value: fileUrl,
        type: "string"
      }
      this.fattureSel.push(coppia);
    }
  }

  fatturaId;

  checkSelected(id)
  {
    this.fatturaId = id;
    this.hideButtons()
    this.fatture.forEach(this.check, this);
  }

  check(fattura: Fattura, index)
  {
    if(fattura.checked && fattura.id != this.fatturaId) this.showButtons();
    if(!fattura.checked && fattura.id == this.fatturaId) this.showButtons();
  }

  showButtons()
  {
    var buttons = document.getElementById('buttons');
    buttons.setAttribute("style", "display:block");
  }

  hideButtons()
  {
    var buttons = document.getElementById('buttons');
    buttons.setAttribute("style", "display:none");
  }

  changeSel(sel)
  {
    this.segreteria = sel;
    var fatture = document.getElementById('icon-fatture');
    var estratto = document.getElementById('icon-estratto');
    var solleciti = document.getElementById('icon-solleciti');
    var fatturelabel = document.getElementById('label-fatture');
    var estrattolabel = document.getElementById('label-estratto');
    var sollecitilabel = document.getElementById('label-solleciti');


    switch(sel)
    {
      case "fatture":
      {
        fatture.setAttribute("src", "assets/icon/fatture-progetti-bianco.svg");
        fatturelabel.setAttribute("style", "color: white;");
        estratto.setAttribute("src", "assets/icon/estratto-conto-grigio.svg");
        estrattolabel.setAttribute("style", "color:#515151;");
        solleciti.setAttribute("src", "assets/icon/solleciti-grigio.svg");
        sollecitilabel.setAttribute("style", "color:#515151;");
        break;
      }
      case "estratto":
      {
        fatture.setAttribute("src", "assets/icon/fatture-progetti-grigio.svg");
        fatturelabel.setAttribute("style", "color:#515151;");
        estratto.setAttribute("src", "assets/icon/estratto-conto-bianco.svg");
        estrattolabel.setAttribute("style", "color: white;");
        solleciti.setAttribute("src", "assets/icon/solleciti-grigio.svg");
        sollecitilabel.setAttribute("style", "color:#515151;");
        break;
      }
      case "solleciti":
      {
        fatture.setAttribute("src", "assets/icon/fatture-progetti-grigio.svg");
        fatturelabel.setAttribute("style", "color:#515151;");
        estratto.setAttribute("src", "assets/icon/estratto-conto-grigio.svg");
        estrattolabel.setAttribute("style", "color:#515151;");
        solleciti.setAttribute("src", "assets/icon/solleciti-bianco.svg");
        sollecitilabel.setAttribute("style", "color: white;");
        break;
      }
    }
  }

  setDateDa()
  {
    this.datePicker.show({
      date: new Date(),
      mode: 'date',
      androidTheme: this.datePicker.ANDROID_THEMES.THEME_HOLO_DARK
    }).then(
      date => this.date1 = this.utilService.getAndroidDateString(date),
      err => console.log('Error occurred while getting date: ', err)
    );
  }

  setDateA()
  {
    this.datePicker.show({
      date: new Date(),
      mode: 'date',
      androidTheme: this.datePicker.ANDROID_THEMES.THEME_HOLO_DARK
    }).then(
      date => this.date2 = this.utilService.getAndroidDateString(date),
      err => console.log('Error occurred while getting date: ', err)
    );
  }

  getNotula(idNotula, nomeFile, isProgNotula)
  {
    var tipo = "";
    if(isProgNotula) tipo = "P";
    else tipo = "N";
    var fileUrl = this.httpClientDataService.BASE_ADDRESS+"/intranet/notula.do?idcliente="+AuthService.clienteSelezionato.id+"&idnotula="+idNotula+"&tipo="+tipo;
    //this.utilService.downloadDocumento(fileUrl, nomeFile);
    nomeFile += ".pdf";
    this.utilService.shareDocumento(fileUrl, nomeFile);
  }

  getEstrattoConto(idCliente, nomeFile, idStruttura)
  {
    var fileUrl = this.httpClientDataService.BASE_ADDRESS+"/intranet/estrattoconto.do?idcliente="+idCliente+"&idstruttura="+idStruttura;
    //this.utilService.downloadDocumento(fileUrl, nomeFile);
    this.utilService.shareDocumento(fileUrl, nomeFile);
  }

  async redirectTo2p2()
  {
    var id = await this.authService.getId();
    id = 1096;
    this.segreteriaService.getP2pToken(id).subscribe((res)=>{
      var token = res.token;
      window.open(this.httpClientDataService.P2PSingleSignOnUrl+token, "_system");
    },
    (error: ErrorResponse) => {
      if(error != null && error.errorMsg != null) this.utilService.presentAlert("Errore", "", error.errorMsg, ["OK"]);
      else if(error!=null) this.utilService.presentAlert("Errore", "", error, ["OK"]);
      else this.utilService.presentAlert("Errore", "", "Errore durante l'sso verso 2P2", ["OK"]);
    });
  }

  cambiaStruttura()
  {
    var i;
    for(i = 0;i < this.strutture.length;i++)
    {
      if(this.idStrutturaSel == this.strutture[i].id) 
        this.strutturaSel = this.strutture[i];
    }
  }

  loadStrutture()
  {
    //this.utilService.showLoading();
    this.segreteriaService.getStrutture(AuthService.clienteSelezionato.id).subscribe((res: StruttureResponse)=>{
      //this.utilService.closeLoading();
      this.strutture = res.strutture;
      if(this.strutture.length > 0) this.strutturaSel = this.strutture[0];
    },
    (error: ErrorResponse) => {
      //this.utilService.closeLoading();
      if(error != null && error.errorMsg != null) this.utilService.presentAlert("Errore", "", error.errorMsg, ["OK"]);
      else if(error!=null) this.utilService.presentAlert("Errore", "", error, ["OK"]);
      else this.utilService.presentAlert("Errore", "", "Errore durante la richiesta lista strutture", ["OK"]);
    });
  }

  cercaFatture()
  {
    this.loadFatture("ricerca");
  }

  loadFatture(fase)
  {
    this.utilService.showLoading();
    var dataA = null;
    var dataDa = null;
    var numeroN = null;
    var numeroP = null;
    if(this.nNotula!= null  && this.nNotula != "") numeroN = this.nNotula;
    if(this.nProgNotula != null  && this.nProgNotula != "") numeroP = this.nProgNotula;
    if(this.date1 != null  && this.date1 != "") dataDa = this.utilService.dateFormatConvert(this.date1);
    if(this.date2 != null  && this.date2 != "") dataA = this.utilService.dateFormatConvert(this.date2);
    var request: FattureRequest;
    this.idCliente = AuthService.clienteSelezionato.id;
    if(fase == "initial") request = this.segreteriaService.createFatturaRequest(this.idCliente, 10, null, null, numeroP, numeroN); 
    else request = this.segreteriaService.createFatturaRequest(this.idCliente,null, dataDa, dataA, numeroP, numeroN);
    this.segreteriaService.getFatture(request).subscribe((res: FattureResponse)=>{
      this.utilService.closeLoading();
      if(res.error){
        this.utilService.presentAlert("Errore", "", res.error, ["OK"]);
      }
      else 
      {
        this.fatture = res.notule;
      }
    },
    (error: ErrorResponse) => {
      this.utilService.closeLoading();
      if(error != null && error.errorMsg != null) this.utilService.presentAlert("Errore", "", error.errorMsg, ["OK"]);
      else if(error!=null) this.utilService.presentAlert("Errore", "", error, ["OK"]);
      else this.utilService.presentAlert("Errore", "", "Errore durante richiesta delle fatture", ["OK"]);
    });
  }

  ngOnInit() {
  }

  trackByDoc(index: number, seg: Fattura): number { return seg.id; }

}
