import { Injectable } from '@angular/core';
import { Observable, of } from  'rxjs';
import { Pair } from './../interface/pair';
import { NotificheRequest } from '../interface/notifiche-request';
import { tap, catchError } from  'rxjs/operators';
import { ErrorResponse } from '../auth/interface/error-response';
import { HttpClient, HttpErrorResponse } from '@angular/common/http';
import { HttpClientDataService } from '../service/http-client-data.service';
import { NotificheResponse } from '../interface/notifiche-response';
import { ArchiviaNotificaResponse } from '../interface/archivia-notifica-response';
import { ArchiviaNotificaRequest } from '../interface/archivia-notifica-request';
import { ParereResponse } from '../interface/parere-response';
import { UtilService } from './util.service';
import { AuthService } from '../auth/service/auth.service';
import { Platform } from '@ionic/angular';
import { platformBrowserDynamicTesting } from '@angular/platform-browser-dynamic/testing';
import { Notifica } from '../interface/notifica';

@Injectable({
  providedIn: 'root'
})
export class NotificheService {
  
  constructor(
    private  httpClient: HttpClient,
    private  httpClientDataService: HttpClientDataService,
    private platform: Platform
  ) {
    this.initService();
  }

  archiviaNotifiche(id: any, archiviare: boolean, notificheSelezionate: number[]) {
    var notifica = this.creaNotificaArchiviazione(id, archiviare, notificheSelezionate);
    var param = this.encodeArchiviaNotifica(notifica);
    return this.httpClient.post<ArchiviaNotificaResponse>(this.httpClientDataService.BASE_ADDRESS+'/intranet/setnotifichedaarchiviare.do', param, this.httpClientDataService.httpOptionsJson)
      .pipe(
      catchError(this.handleError),
      tap( (res: ArchiviaNotificaResponse ) => {

        if (!res.error) {
          this.errorRespose.error = false;
          return res;
        }
        else{
          this.errorRespose.error = true;
          this.errorRespose.errorMsg = res.error;          
        }
      })
    );
  }

  creaNotificaArchiviazione(id, archiviare, notificheSelezionate): ArchiviaNotificaRequest
  {
    var notifiche: ArchiviaNotificaRequest;
    notifiche = {
      cliente: id,
      daArchiviare: archiviare,
      listaNotifiche: notificheSelezionate
    };

    return notifiche;
  }

  encodeArchiviaNotifica(params: ArchiviaNotificaRequest)
  {
    var request ="{\"cliente\" : " + params.cliente + ", \"daArchiviare\" : " + params.daArchiviare + ", \"listaNotifiche\" : [";
    var first = true;
    for(let notifica of params.listaNotifiche)
    {
      if(first) 
      {
        first = false;
        request += "\""+notifica+"\"";
      }
      else request += ", \""+notifica+"\"";
    }
    request += "]}";
    return request;
  }

  initService()
  {
    this.errorRespose = { 
      error: true,
      errorMsg: ""
    };
  }

  errorRespose: ErrorResponse; 

  handleError(error: HttpErrorResponse) {
    this.errorRespose = { 
      error: true,
      errorMsg: ""
    };
    if (error.error instanceof ErrorEvent) {
      this.errorRespose.errorMsg = error.error.message;
    } else {
      this.errorRespose.errorMsg = error.error;
    }
    return of(this.errorRespose);
  };

  getListaNotifiche(idCliente: string, idReferente: string, archiviati: boolean, titolo: string, tipoStruttura: string, strutturaSelezionata: string): Observable<NotificheResponse>
  {
    var richiesta = null;
    if(AuthService.isClienteLoggato) richiesta = this.creaRichiesta(idReferente, -1, 10, null, null, archiviati, titolo, tipoStruttura, strutturaSelezionata);
    else richiesta = this.creaRichiesta(idCliente, idReferente, 10, null, null, archiviati, titolo, tipoStruttura, strutturaSelezionata);
    
    var param = this.encodeBody(richiesta);
    return this.httpClient.post<NotificheResponse>(this.httpClientDataService.BASE_ADDRESS+'/intranet/notifiche.do', param, this.httpClientDataService.httpOptionsJson)
      .pipe(
      catchError(this.handleError),
      tap( (res:  NotificheResponse ) => {
        if (!res.error) {
          let notifiche: Notifica[] = [];
          if(!this.platform.is("desktop"))
            res.notifiche.forEach(element => element.contenuto = element.contenuto.replace(/<br>/g, "\r\n"));
          this.errorRespose.error = false;
          return notifiche;
        }
        else{
          this.errorRespose.error = true;
          this.errorRespose.errorMsg = res.error;          
        }
      })
    );
  }

  resetNotifiche(idReferente: string, struttura: string, idNotifica: number) : Observable<Boolean> {
    var param = "";
    if(!AuthService.isClienteLoggato) param = UtilService.encodeBody({clienteId: -1, referenteId: idReferente, gruppoStrutture: struttura, idNotifica: idNotifica});
    else param = UtilService.encodeBody({clienteId: idReferente, referenteId: -1, gruppoStrutture: struttura, idNotifica: idNotifica});
    return this.httpClient.post<Boolean>(this.httpClientDataService.BASE_ADDRESS+'/intranet/resetNotificheNonLette.do', param, this.httpClientDataService.httpOptions)
     .pipe(
      catchError(this.handleError),
      tap( (res:  Boolean ) => {
        console.log("Reset Eseguito");
        return res;
      })
    );
  }

  isNotificheNonViste(idReferente: string, tipoStruttura: string): Observable<ParereResponse>
  {
    var richiesta = null;
    if(AuthService.isClienteLoggato) richiesta = this.creaRichiesta(idReferente, -1, 10, null, null, false, null, tipoStruttura, null);
    else richiesta = this.creaRichiesta(-1, idReferente, 10, null, null, false, null, tipoStruttura, null);
    var param = this.encodeBody(richiesta);
    return this.httpClient.post<ParereResponse>(this.httpClientDataService.BASE_ADDRESS+'/intranet/notificheNonLette.do', param, this.httpClientDataService.httpOptionsJson)
      .pipe(
      catchError(this.handleError),
      tap( (res:  ParereResponse) => {

        if (!res.error) {
          this.errorRespose.error = false;
          return res;
        }
        else{
          this.errorRespose.error = true;
          this.errorRespose.errorMsg = res.error;          
        }
      })
    );
  }

  creaRichiesta(id, referente, limite, dataDa, dataA, archiviati, titolo, tipostruttura, strutturaSelezionata): NotificheRequest
  {
    var request:NotificheRequest;
    var pair:Pair;
    var pairs: Pair[] = new Array();

    if(archiviati != null)
    {
      pair = {
        key: "archiviato",
        value: archiviati,
        type: "boolean"
      }
      pairs.push(pair);
    }

    if(titolo != null)
    {
      pair = {
        key: "titolo",
        value: titolo,
        type: "string"
      }
      pairs.push(pair);
    }

    if(strutturaSelezionata != null)
    {
      pair = {
        key: "struttura",
        value: strutturaSelezionata,
        type: "int"
      }
      pairs.push(pair);
    }

    if(id != null)
    {
      pair = {
        key: "cliente",
        value: id,
        type: "int"
      }
      pairs.push(pair);
    }
    if(id == null) id = "-1";

    request = {
      cliente: id,
      referente: referente,
      limite: limite,
      gruppoStruttura: tipostruttura,
      filtri: pairs
    };

    return request;
  }

  encodeBody(params: NotificheRequest) {
    var request = "{\"cliente\" : "+params.cliente+",\"referente\" : "+params.referente+",\"limite\" : "+params.limite+",\"gruppoStruttura\" : \""+params.gruppoStruttura+"\",\"filtri\" : {";
    var filtro;
    var first = true;
    var i;
    for (i = 0; i < params.filtri.length; i++) {
      filtro = params.filtri[i];
      if(first) first = false;
      else request += ", ";
      if(filtro.type == "int" || filtro.type == "boolean")
        request += "\""+filtro.key + "\":"+filtro.value;
      else
        request += "\""+filtro.key + "\":\""+filtro.value+"\"";
    }
    request += "}}";
    return request;
  }
}
