import { Component, OnInit, ElementRef } from '@angular/core';
import { EmailComposer } from '@ionic-native/email-composer/ngx';
import { UtilService } from '../../service/util.service';
import { Router } from  "@angular/router";

@Component({
  selector: 'app-businesscall',
  templateUrl: './businesscall.page.html',
  styleUrls: ['./businesscall.page.scss'],
})
export class BusinesscallPage implements OnInit {

  constructor(private emailComposer: EmailComposer, private  router:  Router, private utilService:  UtilService, public element:ElementRef) { }

  ngOnInit() {
  }

  sendMail(form)
  {
    if(!this.privacy) this.utilService.presentAlert("Avviso", "", "Non hai selezionato il checkbox con la Privacy", ["OK"]);
    else {
      var email = this.createMail(form.value);
      this.emailComposer.open(email);
      this.router.navigateByUrl('login');
    }
  }

  privacy: boolean;
  nome: string;
  cognome: string;
  cellulare: string;
  email: string;
  testo: string;

  createMail(value): any
  {
   var corpo = 'Ciao,\r\n'+value.nome+" "+value.cognome+" ha richiesto una call.\r\nIl numero di telefono è "+value.cellulare
    +"\r\nL'indirizzo email è "+value.email+"\r\n\r\nTESTO AGGIUNTIVO:\r\n\r\n"+value.testo+"\r\n\r\n";
    let email = {
      /*to: 'max@mustermann.de',
      cc: 'erika@mustermann.de',
      bcc: ['john@doe.com', 'jane@doe.com'],
      attachments: [
        'file://img/logo.png',
        'res://icon.png',
        'base64:icon.png//iVBORw0KGgoAAAANSUhEUg...',
        'file://README.pdf'
      ],*/
      to: 'amministrazione@2p2.it',
      subject: 'Prenotazione Business Call',
      body: corpo,
      isHtml: true
    }
    return email;
  }

  gotoPrivacy()
  {
    this.router.navigateByUrl('privacy');
  }

  reset()
  {
    this.privacy = false;
    this.nome = "";
    this.cognome = "";
    this.cellulare = "";
    this.email = "";
    this.testo = "";
  }

  back()
  {
    this.router.navigateByUrl('login');
  }

  autosize()
  {
    const textArea = this.element.nativeElement.getElementsByTagName('textarea')[0];
    textArea.style.overflow = 'hidden';
    textArea.style.height = 'auto';
    textArea.style.height = textArea.scrollHeight + 'px';
  }

}
