const LaniakeaModule = (function ($) {
  function ready(fn) {
    if (document.readyState !== "loading") {
      fn();
    } else {
      document.addEventListener("DOMContentLoaded", fn);
    }
  }

  ready(onReady);

  function onReady() {
    //LAZY LOADING IMAGES:
    var lazyloadImages;
    var lazyloadClasses;

    if ("IntersectionObserver" in window) {
      lazyloadImages = document.querySelectorAll("img");

      lazyloadClasses = document.querySelectorAll(".lazyload-row");

      const intersectionObserver = new IntersectionObserver((entries) => {
        entries.forEach(function (entry) {
          if (entry.isIntersecting) {
            console.log("entry", entry.target);

            let _entry = entry.target;
            if (_entry.dataset.src) {
              _entry.src = _entry.dataset.src;
            }

            if (_entry.classList.contains("lazyload-row")) {
              _entry.classList.remove("lazyload-row");
            }

            intersectionObserver.unobserve(_entry);
          }
        });
      });

      lazyloadImages.forEach(function (entry) {
        intersectionObserver.observe(entry);
      });

      lazyloadClasses.forEach(function (entry) {
        intersectionObserver.observe(entry);
      });
    }

    ///
    const Wrapper = document.getElementById("wrapper");
    const docElem = document.documentElement;

    const header = document.querySelector("#main-header");
    const logo = document.querySelector("#main-header #logo");
    const mobileBurger = document.querySelector(".mobile-burger");
    const mainMenuLinks = document.querySelectorAll("#main-header .menu-item");

    const linesBurger = document.querySelectorAll(
      ".mobile-burger .burger-line"
    );
    const mainNav = document.querySelector(".main-nav");

    //widget
    const widgetSearch = document.querySelector(
      ".searchform input[type='submit']"
    );

    $(".blog_widget #s").each(function () {
      $(this).attr("placeholder", "Cerca");
    });

    if (widgetSearch) widgetSearch.value = "";

    //wrapper reset opacity on ready:
    Wrapper.style.opacity = 1;

    let didScroll = false;
    let changeHeaderOn = 50;

    function init() {

      /*

      //FIX da attivare solo per landing page menu mobile 
      mainMenuLinks.forEach((mnu) =>
        mnu.addEventListener("click", function () {
           if (window.location.href.indexOf("#") != -1) {
            document.body.classList.remove("menu-mobile-open");
          } 
        })
      );
      */

      mobileBurger.addEventListener("click", function (event) {
        document.body.classList.toggle("menu-mobile-open");

        if (document.body.classList.contains("menu-mobile-open")) {
          setTimeout(toggleLineBurgerWhite, 400);
        } else {
          toggleLineBurgerWhite();
        }
        mainNav.classList.toggle("visible-mobile");
      });
    }

    function toggleLineBurgerWhite() {
      linesBurger.forEach((el) => {
        el.classList.toggle("stroke-white");
      });
    }

    init();

    $(document).on(
      "click",
      ".wpcf7-not-valid-tip,.wpcf7-response-output",
      function () {
        $(this).fadeOut();
      }
    );
  }
})(jQuery);
