<?php 

class SocialController {
    public static function init(){
        $socials = laniakea_get_socials();
        $arr = [];
    
        array_map(function ($social) use (&$arr) {
            $option = laniakea_option('social_' . $social['name']);
    
            if (!empty($option)) {
                $arr[] = [
                    'link' => $option,
                    'icon' => $social['icon'],
                    'title' => $social['label'],
                    'name' => $social['name']
                ];
            }
        }, $socials);
    
        return [
            'atts' => [
                'align' => 'left',
                'size' => ''
            ],
            'socials' => $arr
        ];
    }
}