<?php

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}


$footer_copy = laniakea_option('footer_copyright');
$post_footer_copy = laniakea_option('post_footer_copyright');

$footer_active_widgets = is_active_sidebar('footer-first-widget-area') + is_active_sidebar('footer-second-widget-area') + is_active_sidebar('footer-third-widget-area') + is_active_sidebar('footer-fourth-widget-area');

$menu_args = array(
	'theme_location' => 'laniakea-footer-menu',
	'depth' => 0,
	'container_class' => 'laniakea-footer-menu',
	'menu_class' => 'footer-menu d-flex block-at-sm',
	'fallback_cb' => 'wp_page_menu'
);
?>



<?php wp_footer(); ?>
</div><!--#wrapper-->
<footer>
	<?php if ($footer_active_widgets) : ?>
		<div class="upper-footer">
			<div class="d-flex block-at-md">

				<?php if (is_active_sidebar('footer-first-widget-area')) : ?>
					<div class="widget-col first-widget-area">
						<?php dynamic_sidebar('footer-first-widget-area'); ?>
					</div>
				<?php endif; ?>

				<?php if (is_active_sidebar('footer-second-widget-area')) : ?>
					<div class="widget-col second-widget-area">
						<?php dynamic_sidebar('footer-second-widget-area'); ?>
					</div>
				<?php endif; ?>

				<?php if (is_active_sidebar('footer-third-widget-area')) : ?>
					<div class="widget-col third-widget-area">
						<?php dynamic_sidebar('footer-third-widget-area'); ?>
					</div>
				<?php endif; ?>

				<?php if (is_active_sidebar('footer-fourth-widget-area')) : ?>
					<div class="widget-col forth-widget-area">
						<?php dynamic_sidebar('footer-fourth-widget-area'); ?>
					</div>
				<?php endif; ?>

			</div>
		</div>
	<?php endif; ?>

	<div class="lower-footer d-flex block-at-sm justify-center">
		<?php echo $footer_copy; ?>
		<?php wp_nav_menu($menu_args); ?>
		<?php echo $post_footer_copy; ?>
	</div>

</footer>


</body>

</html>